import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.n52.math.Algorithm;
import org.n52.math.SatelliteTriangulation;
import org.n52.math.SunTriangulation;
import org.n52.math.TerrainTriangulation;

public class AngleMaps {

	/**
	 * @param args
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {
		if (args.length != 4)
			System.out.println("Please specify year, month, day, utc_time");
		else {
			int year = Integer.parseInt(args[0]);
			int month = Integer.parseInt(args[1]);
			int day = Integer.parseInt(args[2]);
			double utctime = Double.parseDouble(args[3]);
			TerrainTriangulation tertr = new TerrainTriangulation(6378137.0,
					298.257223563);
			SatelliteTriangulation sattr = new SatelliteTriangulation(tertr, 0,
					0, 3000, 35785831 + 6378137);
			Algorithm satazimuthAlg = sattr.getAzimuthAlgorithm();
			Algorithm satzenithangleAlg = sattr.getZenithAngleAlgorithm();
			SunTriangulation suntr = new SunTriangulation(tertr, year, month,
					day, utctime);
			Algorithm sunazimuthAlg = suntr.getAzimuthAlgorithm();
			Algorithm sunzenithangleAlg = suntr.getZenithAngleAlgorithm();

			String date = args[0] + "_" + args[1] + "_" + args[2] + "_"
					+ args[3];

			DataOutputStream ds1 = new DataOutputStream(new FileOutputStream(
					"sataz_" + date));
			DataOutputStream ds2 = new DataOutputStream(new FileOutputStream(
					"satzen_" + date));
			DataOutputStream ds3 = new DataOutputStream(new FileOutputStream(
					"sunaz_" + date));
			DataOutputStream ds4 = new DataOutputStream(new FileOutputStream(
					"sunzen_" + date));

			for (double lat = 85; lat >= -85; lat -= .45)
				for (double lon = -85; lon <= 85; lon += .45) {
					double[] params = new double[2];
					params[0] = lat;
					params[1] = lon;
					double satazimuth = satazimuthAlg.calculate(params);
					double satzenith = satzenithangleAlg.calculate(params);
					double sunazimuth = sunazimuthAlg.calculate(params);
					double sunzenith = sunzenithangleAlg.calculate(params);
					ds1.writeFloat((float) satazimuth);
					ds2.writeFloat((float) satzenith);
					ds3.writeFloat((float) sunazimuth);
					ds4.writeFloat((float) sunzenith);
				}

			ds1.close();
			ds2.close();
			ds3.close();
			ds4.close();
		}
	}
}
