@echo off
echo Multi Sensor Precipitation Geostationary import routine
echo The output represents rainfall intensity values expressed in mm/hr 
echo.
echo.
rem new filename convention: W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+MPEG_C_EUMG_20221027010000_3.bin


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.



copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+MPEG_C_EUMG_%shortfilename1%00_3.bin" 

if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+MPEG_C_EUMG_%shortfilename1%00_3.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+MPEG_C_EUMG_%shortfilename1%00_3.bin" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
rename "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+MPEG_C_EUMG_%shortfilename1%00_3.bin" MPEG%shortfilename1%.grib
"%UtilDir%\wgrib2.exe" -ieee %OutputDrive%\%OutputDir%\tMPEG%shortfilename1% %OutputDrive%\%OutputDir%\MPEG%shortfilename1%.grib 

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\ttMPEG%shortfilename1%.mpr:=map(%OutputDrive%\%OutputDir%\tMPEG%shortfilename1%,genras,Convert,3712,0,Real,4,SwapBytes)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\tttMPEG%shortfilename1%.mpr{dom=value;vr=0:100:0.00001}:=iff(%OutputDrive%\%OutputDir%\ttMPEG%shortfilename1% ge 100000,0,%OutputDrive%\%OutputDir%\ttMPEG%shortfilename1%*3600)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\MPEG_RSS_%shortfilename1%.mpr{dom=value;vr=0:100:0.00001}:=MapMirrorRotate(%OutputDrive%\%OutputDir%\tttMPEG%shortfilename1%,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\MPEG_RSS_%shortfilename1%.mpr %UtilDir%\rss_mpeg


del MPEG%shortfilename1%.grib
del tMPEG*.*
del ttMPEG*.*
del ttt*.*


:END
"%IlwDir%\ilwis.exe" -C closeall