@echo off
echo Regional Instability Index (RII) BUFR Import and Processing
echo.
echo.
echo Note that import can take some time as large number of record need to be processed
echo Various paramer fields selected and point and raster maps are being calculated
echo For quick visualization of the GII file use BUFRDisplay
echo.
echo Relevant coordinate variables are: 14-latitude (code 5001), 15-longitude (code 6001)
echo Relevant parameters are: 17-K_Index (code 13044), 19-Parcel_Lifted_Index (code 13042), 
echo 21-Precipitable_Water (code 13016) 18-KO_Index (code 13045), 20-Maximum_Bouyancy (code 13046)
echo.
echo.
rem new file name convention: W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+RII_C_EUMG_20221027021000_3.bin


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*
set MSG_number=1

copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+RII_C_EUMG_%shortfilename1%00_3.bin" %OutputDrive%\%OutputDir%\*.*
if exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+RII_C_EUMG_%shortfilename1%00_3.bin" GOTO START

if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+RII_C_EUMG_%shortfilename1%00_3.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+RII_C_EUMG_%shortfilename1%00_3.bin" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START


ren "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET10+RII_C_EUMG_%shortfilename1%00_3.bin" "RII%shortfilename1%"



copy RII%shortfilename1% "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" >NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe RII%shortfilename1% -oddump.csv >mess.txt 2>&1

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" >NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\RII%shortfilename1%"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv 
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 16 15 18 20 22 19 21 < dump2.csv > dump3.csv 



echo.
echo.
echo Importing data from BUFR file into ILWIS and create output maps
echo Import GII bufr file (x,y,k_index, parcel lifted index (to 500 hPa), 
echo Precipitable water (kg m-2), KO_index, maximum bouyancy)
echo Wait until routine is completed
echo.
echo.
echo Importing BUFR table
echo.




"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS%shortfilename1%:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,x(value.dom{-90.0000:90.0000:1e-005}),y(value.dom{-90.0000:90.0000:1e-005}),k_index(value.dom{-1000:1000:0.1}),lifted_index(value.dom{-1000:1000:0.1}),prec_water(value.dom{-10000:10000:0.1}),ko_index(value.dom{-1000:1000:1}),max_buoyancy(value.dom{-1000:1000:1})

echo creation of point maps
echo.

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_k_index%shortfilename1%.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\rii_RSS%shortfilename1%',x,y,LatlonWGS84,k_index);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_lifted_index%shortfilename1%.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\rii_RSS%shortfilename1%',x,y,LatlonWGS84,lifted_index);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_prec_water%shortfilename1%.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\rii_RSS%shortfilename1%',x,y,LatlonWGS84,prec_water);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_ko_index%shortfilename1%.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\rii_RSS%shortfilename1%',x,y,LatlonWGS84,KO_index);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_max_buoyancy%shortfilename1%.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\rii_RSS%shortfilename1%',x,y,LatlonWGS84,max_buoyancy);


echo creation of raster maps, using point size of 15 as the spatial resolution of the data is 45 km


"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_k_index%shortfilename1%.mpr{dom=value;vr=-100.0:100.0:0.1}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\RII_RSS_k_index%shortfilename1%,'%UtilDir%\gii_grf'.grf,5);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_lifted_index%shortfilename1%.mpr{dom=value;vr=-100.0:100.0:0.1}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\RII_RSS_lifted_index%shortfilename1%,'%UtilDir%\gii_grf'.grf,5);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_prec_water%shortfilename1%.mpr{dom=value;vr=-1000.0:1000.0:0.01}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\RII_RSS_prec_water%shortfilename1%,'%UtilDir%\gii_grf'.grf,5);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_ko_index%shortfilename1%.mpr{dom=value;vr=-1000.0:1000.0:0.01}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\RII_RSS_KO_index%shortfilename1%,'%UtilDir%\gii_grf'.grf,5);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\RII_RSS_max_buoyancy%shortfilename1%.mpr{dom=value;vr=-1000.0:1000.0:0.01}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\RII_RSS_max_buoyancy%shortfilename1%,'%UtilDir%\gii_grf'.grf,5);

rem Display data

copy %UtilDir%\mpl_substitutename.bat >NUL
copy %UtilDir%\gii_grf.grf >NUL
copy %UtilDir%\gii_grf.csy >NUL
copy %UtilDir%\GI_rssindexmaps386.mpv >NUL

cmd /c mpl_substitutename.bat ____ %shortfilename1% GI_rssindexmaps386.mpv > RI_rssindexmaps%shortfilename1%.mpv


rem display imported data - ilwis should be active / open
"%UtilDir%\DDEClient.exe" "open %OutputDrive%\%OutputDir%\RI_rssindexmaps%shortfilename1%.mpv -noask"

rem delete obsolete objects and files
del GI_rssindexmaps386.mpv


:END

del RII%shortfilename1%
del dump*.csv
del ConvertCSV.class
del mpl_substitutename.bat



"%IlwDir%\ilwis.exe" -C closeall