@echo off

echo import and process GLOBAL MODIS FIRE PRODUCT 
echo file name syntax of the fire product is "MOD14.A2013252.0545.005.NRT.hdf"
echo file name syntax of the fire product is "MYD14.A2013252.0630.005.NRT.hdf"


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set MODIS_DAY=%9

cd\
%OutputDrive%
cd %OutputDir%

rem MOD14=TERRA
rem MYD14=AQUA



echo *%OutputDrive%\%OutputDir%

copy %InputDrive%\%InputDir%\MOD14.?20??%9.????.005.NRT.hdf %OutputDrive%\%OutputDir%\*.*
copy %InputDrive%\%InputDir%\MYD14.?20??%9.????.005.NRT.hdf %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\*.005.NRT.hdf" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\MOD14*" and "%InputDrive%\%InputDir%\MYD14*" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current year - julian day stamp used is %shortfilename1% - %MODIS_DAY%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

for %%j in (MOD14.A*.hdf) do cmd /c "%IlwDir%\Extensions\Geonetcast-Toolbox\toolbox_batchroutines\modis_extractfiresTERRA.bat" %%j
for %%j in (MYD14.A*.hdf) do cmd /c "%IlwDir%\Extensions\Geonetcast-Toolbox\toolbox_batchroutines\modis_extractfiresAqua.bat" %%j

cd\
%OutputDrive%
cd %OutputDir%

for %%j in (*.shp) do cmd /c "%IlwDir%\Extensions\Geonetcast-Toolbox\toolbox_batchroutines\modisfire_ilwisimport.bat" %%j

del *.shp
del *.dbf
del *.shx



rem combine ascii files in single table

copy "%OutputDrive%\%OutputDir%\fire*.txt" "%OutputDrive%\%OutputDir%\MODISfire_%shortfilename1%%MODIS_DAY%.txt" 

rem import final ascii table in ilwis and create pointmap and raster map

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\MODISfire_%shortfilename1%%MODIS_DAY%'.tbt:=table('%OutputDrive%\%OutputDir%\MODISfire_%shortfilename1%%MODIS_DAY%'.txt,Comma,Convert,none,Org_no(string),Line(value.dom{0:10000:1}),Sample(value.dom{0:10000:1}),Y(value.dom{-90.000000:90.000000:1e-006}),X(value.dom{-180.000000:180.000000:1e-006}),Conf(value.dom{0:100:1}),AdjCloud(value.dom{0:100:1}),AdjWater(value.dom{0:100:1}),R2(value.dom{-100:100.000000:1e-006}),T21(value.dom{100.000000:750.000000:1e-006}),T31(value.dom{100.000000:750.000000:1e-006}),Power(value.dom{0.000000:2500.000000:1e-006}),MedianDT(value.dom{-10000000:10000000:1}),MeanT21(value.dom{100.000000:750.000000:1e-006}),MeanT31(value.dom{100.000000:750.000000:1e-006}),SD_T21(value.dom{0.000000:200.000000:1e-006}),SD_T31(value.dom{0.000000:200.000000:1e-006}),SD_DT(value.dom{0.000000:200.000000:1e-006}))
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\MODISfire_%shortfilename1%%MODIS_DAY%'.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\MODISfire_%shortfilename1%%MODIS_DAY%','%UtilDir%\modis_fire',pnt)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\MODISfire_%shortfilename1%%MODIS_DAY%'.mpr{dom=MODISfire_%shortfilename1%%MODIS_DAY%}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\MODISfire_%shortfilename1%%MODIS_DAY%,'%UtilDir%\modis_fire'.grf,1)


if not exist "%OutputDrive%\%OutputDir%\fireT*.tbt" goto DELNEXT
del fireT%shortfilename1%%MODIS_DAY%_*.tbt
del fireT%shortfilename1%%MODIS_DAY%_*.mpp
del fireT%shortfilename1%%MODIS_DAY%_*.tb#
del fireT%shortfilename1%%MODIS_DAY%_*.pt#
del fireT%shortfilename1%%MODIS_DAY%_*.dom

:DELNEXT
if not exist "%OutputDrive%\%OutputDir%\fireA*.tbt" goto DELFIN
del fireA%shortfilename1%%MODIS_DAY%_*.tbt
del fireA%shortfilename1%%MODIS_DAY%_*.mpp
del fireA%shortfilename1%%MODIS_DAY%_*.tb#
del fireA%shortfilename1%%MODIS_DAY%_*.pt#
del fireA%shortfilename1%%MODIS_DAY%_*.dom

:DELFIN

del fire*.txt
del MODISfire_%shortfilename1%%MODIS_DAY%.txt


:END
"%IlwDir%\ilwis.exe" -C closeall

