@echo off
rem input filename format GLDAS_NOAH025_3H.A20200201.0000.021.nc4
rem loop of 8 files


call inputparam.bat

echo off

set longfilename=%1
set shortfilename1=%longfilename:~18,4%
set shortfilename2=%longfilename:~22,2%
set shortfilename3=%longfilename:~24,2%
set shortfilename4=%longfilename:~27,4%

echo.
echo processing timestep %shortfilename1%%shortfilename2%%shortfilename3% time step = %shortfilename4% 
echo.

rem Average Surface Temperature = AvgSurft (Kelvin)
%GdalDir%\gdal_translate -of ilwis HDF5:"GLDAS_NOAH025_3H.A%shortfilename1%%shortfilename2%%shortfilename3%.%shortfilename4%.021.nc4"://AvgSurfT_inst AvgSurfT.mpr -q

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_AvgSurfT_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr:=MapMirrorRotate(AvgSurfT,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\gldas_AvgSurfT_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr %UtilDir%\gldas_025

rem Average Evapotranspiration (converted from kg/m2/s-1 to mm/3 hrs)
%GdalDir%\gdal_translate -of ilwis HDF5:"GLDAS_NOAH025_3H.A%shortfilename1%%shortfilename2%%shortfilename3%.%shortfilename4%.021.nc4"://Evap_tavg Evap_tavg.mpr -q

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\Evap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr{dom=value;vr=-20:20:0.00000001}:=Evap_tavg*10800
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_Evap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr:=MapMirrorRotate(Evap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\gldas_Evap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr %UtilDir%\gldas_025

rem Average Pot_Evapotranspiration (converted from W/m2 to mm/3 hrs)
%GdalDir%\gdal_translate -of ilwis HDF5:"GLDAS_NOAH025_3H.A%shortfilename1%%shortfilename2%%shortfilename3%.%shortfilename4%.021.nc4"://PotEvap_tavg PotEvap_tavg.mpr -q

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\PotEvap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr{dom=value;vr=-20:20:0.00000001}:=PotEvap_tavg*10800/2450000
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_PotEvap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr:=MapMirrorRotate(PotEvap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\gldas_PotEvap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr %UtilDir%\gldas_025

rem Rainf_f_tavg_long_name=Total precipitation rate (converted from kg/m2/s1 to mm/3 hrs)
%GdalDir%\gdal_translate -of ilwis HDF5:"GLDAS_NOAH025_3H.A%shortfilename1%%shortfilename2%%shortfilename3%.%shortfilename4%.021.nc4"://Rainf_f_tavg Rainf_f_tavg.mpr -q

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\Rainf_f_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr{dom=value;vr=-20:100:0.00000001}:=Rainf_f_tavg*10800
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_Rainf_f_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr:=MapMirrorRotate(Rainf_f_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\gldas_Rainf_f_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr %UtilDir%\gldas_025


rem The model soil moisture data was converted from kg/m2 to m3/m3 by using the formula SM[m3/m3] = SM[kg/m2] * 0.001 * 1/d, 
rem where d is the thickness of the soil layer in meters.The factor 0.001 is due to the assumption that 1kg of water represents 1000cm3, which is 0.001m3
rem The GLDAS Noah Land Surface Model four soil layers with the bottom depth at 0.1, 0.4, 1.0 and 2.0m respectively

rem SoilMoi0_10cm=Soil moisture from 0 to 10 cm depth (converted from kg/m2 to m3/m3 - volumetric soil moisture)
%GdalDir%\gdal_translate -of ilwis HDF5:"GLDAS_NOAH025_3H.A%shortfilename1%%shortfilename2%%shortfilename3%.%shortfilename4%.021.nc4"://SoilMoi0_10cm_inst SoilMoi0_10cm_inst.mpr -q

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SoilMoi0_10cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr{dom=value;vr=-20:100:0.00000001}:=SoilMoi0_10cm_inst*0.001*(1/0.1)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_SoilMoi0_10cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr:=MapMirrorRotate(SoilMoi0_10cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\gldas_SoilMoi0_10cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr %UtilDir%\gldas_025

rem SoilMoi10_40cm=Soil moisture from 10 to 40 cm depth (converted from kg/m2 to m3/m3 - volumetric soil moisture)
%GdalDir%\gdal_translate -of ilwis HDF5:"GLDAS_NOAH025_3H.A%shortfilename1%%shortfilename2%%shortfilename3%.%shortfilename4%.021.nc4"://SoilMoi10_40cm_inst SoilMoi10_40cm_inst.mpr -q

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SoilMoi10_40cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr{dom=value;vr=-20:100:0.00000001}:=SoilMoi10_40cm_inst*0.001*(1/0.4)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_SoilMoi10_40cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr:=MapMirrorRotate(SoilMoi10_40cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\gldas_SoilMoi10_40cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr %UtilDir%\gldas_025

rem SoilMoi40_100cm=Soil moisture from 40 to 100 cm depth (converted from kg/m2 to m3/m3 - volumetric soil moisture)
%GdalDir%\gdal_translate -of ilwis HDF5:"GLDAS_NOAH025_3H.A%shortfilename1%%shortfilename2%%shortfilename3%.%shortfilename4%.021.nc4"://SoilMoi40_100cm_inst SoilMoi40_100cm_inst.mpr -q

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SoilMoi40_100cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr{dom=value;vr=-20:100:0.00000001}:=SoilMoi10_40cm_inst*0.001*(1/0.6)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_SoilMoi40_100cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr:=MapMirrorRotate(SoilMoi40_100cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\gldas_SoilMoi40_100cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr %UtilDir%\gldas_025

rem SoilMoi40_100cm=Soil moisture from 100 to 200 cm depth (converted from kg/m2 to m3/m3 - volumetric soil moisture)
%GdalDir%\gdal_translate -of ilwis HDF5:"GLDAS_NOAH025_3H.A%shortfilename1%%shortfilename2%%shortfilename3%.%shortfilename4%.021.nc4"://SoilMoi40_100cm_inst SoilMoi100_200cm_inst.mpr -q

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SoilMoi100_200cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr{dom=value;vr=-20:100:0.00000001}:=SoilMoi10_40cm_inst*0.001*(1/1)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_SoilMoi100_200cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr:=MapMirrorRotate(SoilMoi100_200cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\gldas_SoilMoi100_200cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mpr %UtilDir%\gldas_025


rem delete obsolete objects

del %OutputDrive%\%OutputDir%\AvgSurfT.mp*
del %OutputDrive%\%OutputDir%\Evap_tavg.mp*
del %OutputDrive%\%OutputDir%\Evap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mp*
del %OutputDrive%\%OutputDir%\PotEvap_tavg.mp*
del %OutputDrive%\%OutputDir%\PotEvap_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mp*
del %OutputDrive%\%OutputDir%\Rainf_f_tavg.mp*
del %OutputDrive%\%OutputDir%\Rainf_f_tavg_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mp*

del %OutputDrive%\%OutputDir%\SoilMoi0_10cm_inst.mp*
del %OutputDrive%\%OutputDir%\SoilMoi0_10cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mp*

del %OutputDrive%\%OutputDir%\SoilMoi10_40cm_inst.mp*
del %OutputDrive%\%OutputDir%\SoilMoi10_40cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mp*

del %OutputDrive%\%OutputDir%\SoilMoi40_100cm_inst.mp*
del %OutputDrive%\%OutputDir%\SoilMoi40_100cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mp*

del %OutputDrive%\%OutputDir%\SoilMoi100_200cm_inst.mp*
del %OutputDrive%\%OutputDir%\SoilMoi100_200cm_inst_%shortfilename1%%shortfilename2%%shortfilename3%_%shortfilename4%.mp*