
@echo off
rem Humidity product analysed by cloud information product 
rem at 300, 400, 500, 700, 850, 925 and 1000 hPa



set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*

copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_300hPa.AWX.gz" %OutputDrive%\%OutputDir%\*.*
copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_400hPa.AWX.gz" %OutputDrive%\%OutputDir%\*.*
copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_500hPa.AWX.gz" %OutputDrive%\%OutputDir%\*.*
copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_700hPa.AWX.gz" %OutputDrive%\%OutputDir%\*.*
copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_850hPa.AWX.gz" %OutputDrive%\%OutputDir%\*.*
copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_925hPa.AWX.gz" %OutputDrive%\%OutputDir%\*.*
copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_1000hPa.AWX.gz" %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_300hPa.AWX.gz" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_****hPa.AWX.gz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START



"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_300hPa.AWX.gz
"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_400hPa.AWX.gz
"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_500hPa.AWX.gz
"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_700hPa.AWX.gz
"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_850hPa.AWX.gz
"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_925hPa.AWX.gz
"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_1000hPa.AWX.gz


ren Z_SATE_C_BAWX_*_P_FY2H_HPF_300_OTG_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_300hPa.AWX
ren Z_SATE_C_BAWX_*_P_FY2H_HPF_400_OTG_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_400hPa.AWX
ren Z_SATE_C_BAWX_*_P_FY2H_HPF_500_OTG_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_500hPa.AWX
ren Z_SATE_C_BAWX_*_P_FY2H_HPF_700_OTG_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_700hPa.AWX
ren Z_SATE_C_BAWX_*_P_FY2H_HPF_850_OTG_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_850hPa.AWX
ren Z_SATE_C_BAWX_*_P_FY2H_HPF_925_OTG_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_925hPa.AWX
ren Z_SATE_C_BAWX_*_P_FY2H_HPF_01K_OTG_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_1000hPa.AWX



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\cma_hpf300_FY2H_%shortfilename1%:=map('%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_300hPa.AWX',genras,Convert,1001,2002,byte,1,NoSwap)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\cma_hpf400_FY2H_%shortfilename1%:=map('%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_400hPa.AWX',genras,Convert,1001,2002,byte,1,NoSwap)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\cma_hpf500_FY2H_%shortfilename1%:=map('%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_500hPa.AWX',genras,Convert,1001,2002,byte,1,NoSwap)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\cma_hpf700_FY2H_%shortfilename1%:=map('%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_700hPa.AWX',genras,Convert,1001,2002,byte,1,NoSwap)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\cma_hpf850_FY2H_%shortfilename1%:=map('%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_850hPa.AWX',genras,Convert,1001,2002,byte,1,NoSwap)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\cma_hpf925_FY2H_%shortfilename1%:=map('%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_925hPa.AWX',genras,Convert,1001,2002,byte,1,NoSwap)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\cma_hpf1000_FY2H_%shortfilename1%:=map('%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_1000hPa.AWX',genras,Convert,1001,2002,byte,1,NoSwap)


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\cma_hpf300_FY2H_%shortfilename1%.mpr %UtilDir%\FY2H_clt.grf 
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\cma_hpf400_FY2H_%shortfilename1%.mpr %UtilDir%\FY2H_clt.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\cma_hpf500_FY2H_%shortfilename1%.mpr %UtilDir%\FY2H_clt.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\cma_hpf700_FY2H_%shortfilename1%.mpr %UtilDir%\FY2H_clt.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\cma_hpf850_FY2H_%shortfilename1%.mpr %UtilDir%\FY2H_clt.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\cma_hpf925_FY2H_%shortfilename1%.mpr %UtilDir%\FY2H_clt.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\cma_hpf1000_FY2H_%shortfilename1%.mpr %UtilDir%\FY2H_clt.grf




copy "%UtilDir%\mpl_substitutename.bat"
copy "%UtilDir%\cma_hpf_FY2H_master.mpl"

cmd /c mpl_substitutename.bat __ _%shortfilename1% cma_hpf_FY2H_master.mpl > cma_hpf_FY2H_%shortfilename1%.mpl


del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_300hPa.AWX.gz
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_400hPa.AWX.gz
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_500hPa.AWX.gz
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_700hPa.AWX.gz
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_850hPa.AWX.gz
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_925hPa.AWX.gz
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_1000hPa.AWX.gz

del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_300hPa.AWX
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_400hPa.AWX
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_500hPa.AWX
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_700hPa.AWX
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_850hPa.AWX
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_925hPa.AWX
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2H_HPF_MLT_003_NOM_1000hPa.AWX

del cma_hpf_FY2H_master.mpl
del mpl_substitutename.bat

:END
"%IlwDir%\ilwis.exe" -C closeall