
@echo off
rem Import of the Atmospheric motion vectors
rem output table columns need further specifications, now only called a, b, c, etc 
rem import of the IR1_006 and IR3_006
rem sample file name Z_SATE_C_BABJ_20120609210000_O_FY2G_AMV_IR1_006_OTG.AWX.gz
rem convert table to point map and use table domain
rem display pointmap and use symbol as arrow option 
rem wind direction is column B
rem wind speed is column C


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*

copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR1_006_OTG.AWX.gz" "%OutputDrive%\%OutputDir%\*.*"
copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR3_006_OTG.AWX.gz" "%OutputDrive%\%OutputDir%\*.*"


if not exist "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR1_006_OTG.AWX.gz" goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR3_006_OTG.AWX.gz" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR*_006_OTG.AWX.gz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START


"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR1_006_OTG.AWX.gz
"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR3_006_OTG.AWX.gz

ren Z_SATE_C_BAWX_*_FY2G_AMV_IR1_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR1_006_OTG.AWX
ren Z_SATE_C_BAWX_*_FY2G_AMV_IR3_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR3_006_OTG.AWX

"%UtilDir%\AmvToILWISTable.exe" Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR1_006_OTG.AWX "%OutputDrive%\%OutputDir%\cma_amv_ir1_FY2G_%shortfilename1%"
"%UtilDir%\AmvToILWISTable.exe" Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR3_006_OTG.AWX "%OutputDrive%\%OutputDir%\cma_amv_ir3_FY2G_%shortfilename1%"

del "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR1_006_OTG.AWX.gz"
del "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR1_006_OTG.AWX"
del "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR3_006_OTG.AWX.gz"
del "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_AMV_IR3_006_OTG.AWX"

:END
"%IlwDir%\ilwis.exe" -C closeall