@echo off 
echo sea surface temperature inferred from the MODIS sensor 
echo Sea Surface Temperature
echo units: degree Celcius
echo filename convention UCT_nsomalia_MODIS_sst_20110330.nc.bz2
echo produced by UCT

set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\UCT_nsomalia_MODIS_sst_%shortfilename1%.nc.bz2" "%OutputDrive%\%OutputDir%\*.*"

if not exist "%OutputDrive%\%OutputDir%\UCT_nsomalia_MODIS_sst_%shortfilename1%.nc.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\UCT_nsomalia_MODIS_sst_%shortfilename1%.nc.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START



%UtilDir%\7z e UCT_nsomalia_MODIS_sst_%shortfilename1%.nc.bz2

"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"UCT_nsomalia_MODIS_sst_%shortfilename1%.nc":sst %OutputDrive%\%OutputDir%\UCT_nsomalia_MODIS_sst_%shortfilename1%.mpr

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\UCT_nsomalia_MODIS_sst_%shortfilename1%.mpr %UtilDir%\UCT_nsomalia.grf;

del UCT_nsomalia_MODIS_sst_%shortfilename1%.nc.bz2
del UCT_nsomalia_MODIS_sst_%shortfilename1%.nc
del UCT_nsomalia_MODIS_sst_%shortfilename1%.grf
del UCT_nsomalia_MODIS_sst_%shortfilename1%.csy
del UCT_nsomalia_MODIS_sst_%shortfilename1%.mpr.aux.xml



:END
"%IlwDir%\ilwis.exe" -C closeall
