@echo off 
echo output WB map is a value map, value ranges from 0-255
echo Proba WB, water body has value of 75 and 150
echo See http://http://land.copernicus.eu/global/sites/default/files/products/GIOGL1_PUM_WBV2_I1.20.pdf
echo file name expected is g2_BIOPAR_WB_201804010000_AFRI_PROBAV_V2.0.1.zip

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


set longfilename=%1
set shortfilename1=%longfilename:~0,8%


copy %inputDrive%\%InputDir%\g2_BIOPAR_WB_%shortfilename1%0000_AFRI_PROBAV_V2*.zip 
ren g2_BIOPAR_WB_%shortfilename1%0000_AFRI_PROBAV_V2*.zip WB_%shortfilename1%0000_AFRI.ZIP

if not exist "%OutputDrive%\%OutputDir%\WB_%shortfilename1%0000_AFRI.ZIP" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\WB_%shortfilename1%0000_AFRI.ZIP" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START



%UtilDir%\7z e WB_%shortfilename1%0000_AFRI.ZIP %shortfilename1%/g2_BIOPAR_WB-WB_%shortfilename1%0000_AFRI_PROBAV_V2.0.1.tiff



ren g2_BIOPAR_WB-WB_%shortfilename1%0000_AFRI_PROBAV_V*.tiff proba_SWB%shortfilename1%.tif


"%GdalDir%\gdal_translate.exe" -of ilwis proba_SWB%shortfilename1%.tif Proba_SWB%shortfilename1%.mpr


"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\Proba_SWB%shortfilename1%'.mpr '%UtilDir%\Proba_V_Afr';


del proba_SWB%shortfilename1%.tif
del Proba_SWB%shortfilename1%.grf
del Proba_SWB%shortfilename1%.csy
del WB_%shortfilename1%0000_AFRI.ZIP
del Proba_SWB%shortfilename1%.mpr.aux.xml

:END
"%IlwDir%\ilwis.exe" -C closeall