@echo off 
echo output NDVI map is a value map, value ranges from 0 to 0.92
echo Proba NDVI
echo input file expected = c_gls_NDVI_yyyymmdd0000_AFRI_PROBAV_V2.2.1.zip

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


set longfilename=%1
set shortfilename1=%longfilename:~0,8%


copy %inputDrive%\%InputDir%\c_gls_NDVI_%shortfilename1%0000_AFRI_PROBAV_V*.zip 
ren c_gls_NDVI_%shortfilename1%0000_AFRI_PROBAV_V*.zip NDVI_%shortfilename1%0000_AFRI.ZIP

if not exist "%OutputDrive%\%OutputDir%\NDVI_%shortfilename1%0000_AFRI.ZIP" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\NDVI_%shortfilename1%0000_AFRI.ZIP" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START



%UtilDir%\7z e NDVI_%shortfilename1%0000_AFRI.ZIP %shortfilename1%/c_gls_NDVI_%shortfilename1%0000_AFRI_PROBAV_V*.nc



ren c_gls_NDVI_%shortfilename1%0000_AFRI_PROBAV_V*.nc proba_ndvi%shortfilename1%.nc


"%GdalDir%\gdal_translate.exe" -of ilwis hdf5:"proba_ndvi%shortfilename1%.nc"://NDVI ndv_p_%shortfilename1%.mpr


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\Proba_ndvi%shortfilename1%'.mpr{dom=value;vr=0.000:0.92:0.001}:=('%OutputDrive%\%OutputDir%\ndv_p_%shortfilename1%'/250-0.08);

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\Proba_ndvi%shortfilename1%'.mpr '%UtilDir%\Proba_V_Afr';


del ndv_p_%shortfilename1%.mp* 
rem del ndv_p_%shortfilename1%.csy
del proba_ndvi%shortfilename1%.nc
del NDVI_%shortfilename1%0000_AFRI.ZIP 


:END
"%IlwDir%\ilwis.exe" -C closeall