@echo off
echo Import METOP AVHRR files as diseminated by EUMETCast
echo Raw File name expected is AVHR_xxx_1B_M01_20170906135203Z_20170906135503Z_N_O_20170906142755Z.bz2
echo If compressed from EUMETCast file needs to be unzipped before use 
echo When unzipped there is no filename extension
echo Sample File Name expected is AVHR_xxx_1B_M02_20120608065503Z_20120608065803Z_N_O_20120608073642Z
echo METOP-A = M02 in the filenames
echo METOP-B = M01 in the filenames 
echo Processing Level =  both 1B and TOA radiances with geolocation info

echo.
echo.



set longfilename=%1
set shortfilename1=%longfilename%
set shortfilename2=%longfilename:~0,-4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%


echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.
echo file name = %shortfilename1%

copy "%inputDrive%\%InputDir%\%shortfilename1%" 


echo off
if not exist "%OutputDrive%\%OutputDir%\%shortfilename1%"  goto MESSAGE
echo The file(s) "%OutputDrive%\%OutputDir%\%shortfilename1%" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your File Name settings
echo Your current File Name used is %shortfilename1%
echo Data is retrieved from %inputDrive%\%InputDir%\



pause

GOTO END

:START

rem import data in ilwis format
"%UtilDir%\7z" e "%OutputDrive%\%OutputDir%\%shortfilename1%" 

java -jar "%UtilDir%\AVHRR_Importer.jar" -of ilwis %shortfilename2% "%OutputDrive%\%OutputDir%\%shortfilename1:~0,4%%shortfilename1:~8,38%"




rem delete obsolete objects

del "%OutputDrive%\%OutputDir%\%shortfilename1%"



:END
"%IlwDir%\ilwis.exe" -C closeall