@echo off
echo MPEF TOZ-import BUFR Import and Processing
echo TOZ [DU]
echo For the undefined grid no information is avaialble from the source bufr data file
echo Use is made of the MSG projection
echo. 
echo Note that import can take some time as large number of record need to be processed
echo Be patient as more than 1 million records need to be processed
echo.
echo For quick visualization of the TOZ file use BUFRDisplay, at least version 4.2
echo Relevant coordinate variables are: 12-latitude (code 5002), 13-longitude (code 6002)
echo Relevant parameters are: 16-Total_Ozone (code 13003)
echo.
echo.
rem file name convention is L-000-MSG1__-MPEF_IODC___-TOZ______-000001___-201701010045-__

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%


copy "%InputDrive%\%InputDir%\L-000-MSG1__-MPEF_IODC___-TOZ______-00000?___-%shortfilename1%-__*.*" 


if not exist "%InputDrive%\%InputDir%\L-000-MSG1__-MPEF_IODC___-TOZ______-000001___-%shortfilename1%-__"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\L-000-MSG1__-MPEF_IODC___-TOZ______-000001___-%shortfilename1%-__" will be copied to your current working directory
echo.
echo.

GOTO START


:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START


rename "L-000-MSG1__-MPEF_IODC___-TOZ______-000001___-%shortfilename1%-__" TOZ%shortfilename1%


echo.
echo.
echo Renamed input file = TOZ%shortfilename1%
echo.
echo.


copy TOZ%shortfilename1% "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe TOZ%shortfilename1% -oddump.csv > mess.txt 2>&1

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\TOZ%shortfilename1%"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 14 13 17 < dump2.csv > dump3.csv 

echo.
echo.
echo Importing data from BUFR file into ILWIS and create output maps
echo.

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\toz%shortfilename1%.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,X(value.dom{-90:180:0.01}),Y(value.dom{-90:90:0.01}),TOZ(value.dom{0:10000:1}))

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\toz_pointsIODC%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\toz%shortfilename1%,X,Y,LatlonWGS84,TOZ)

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\toz_gridIODC%shortfilename1%.mpr{dom=value;vr=0:1000:1}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\toz_pointsIODC%shortfilename1%,'%UtilDir%\msg_IODC'.grf,3)


del dump*.csv
del ConvertCSV.class
del toz%shortfilename1%



:END
"%IlwDir%\ilwis.exe" -C closeall