@echo off

rem Down-welling Surface Short-wave Radiation Flux (DSSF)
rem MDI key="DSSF">SCALING_FACTOR=10</MDI> 
rem  <MDI key="DSSF">OFFSET=0</MDI> 
rem  <MDI key="DSSF">MISSING_VALUE=-1</MDI> 
rem  <MDI key="DSSF">UNITS=W/m**2</MDI> 
rem  <MDI key="DSSF">CAL_SLOPE=1</MDI> 
rem  <MDI key="DSSF">CAL_OFFSET=0</MDI> 


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*

copy %InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_DSSF_SAme_%shortfilename1%.bz2 %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_DSSF_SAme_%shortfilename1%.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_DSSF_SAme_%shortfilename1%.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_DSSF_SAme_%shortfilename1%.bz2

"%gdalDir%\gdal_translate" -of ilwis hdf5:"S-LSA_-HDF5_LSASAF_MSG_DSSF_SAme_%shortfilename1%"://DSSF "%OutputDrive%\%OutputDir%\same_%shortfilename1%"



"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\same_%shortfilename1%.mpr %UtilDir%\lsa_same;



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\LSA_dssf_same%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\same_%shortfilename1% gt 0,%OutputDrive%\%OutputDir%\same_%shortfilename1%/10.00,?)



del *.xml
del same_%shortfilename1%.*

del S-LSA_-HDF5_LSASAF_MSG_DSSF_SAme_*.*



:END
"%IlwDir%\ilwis.exe" -C closeall