@echo off
rem Down-welling Surface Long-wave Radiation Flux 
rem  <MDI key="DSLF">SCALING_FACTOR=10</MDI> 
rem  <MDI key="DSLF">OFFSET=0</MDI> 
rem  <MDI key="DSLF">MISSING_VALUE=0</MDI> 
rem  <MDI key="DSLF">UNITS=Wm-2</MDI> 
rem  <MDI key="DSLF">CAL_SLOPE=999</MDI> 
rem  <MDI key="DSLF">CAL_OFFSET=999</MDI> 


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*

copy %InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_DSLF_NAfr_%shortfilename1%.bz2 %OutputDrive%\%OutputDir%\*.*
copy %InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_DSLF_SAfr_%shortfilename1%.bz2 %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_DSLF_NAfr_%shortfilename1%.bz2" goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_DSLF_SAfr_%shortfilename1%.bz2" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_DSLF_*Afr_%shortfilename1%.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_DSLF_NAfr_%shortfilename1%.bz2
"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_DSLF_SAfr_%shortfilename1%.bz2

"%gdalDir%\gdal_translate" -of ilwis hdf5:"S-LSA_-HDF5_LSASAF_MSG_DSLF_NAfr_%shortfilename1%"://DSLF "%OutputDrive%\%OutputDir%\nafr_%shortfilename1%"
"%gdalDir%\gdal_translate" -of ilwis hdf5:"S-LSA_-HDF5_LSASAF_MSG_DSLF_SAfr_%shortfilename1%"://DSLF "%OutputDrive%\%OutputDir%\safr_%shortfilename1%"


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\nafr_%shortfilename1%.mpr %UtilDir%\lst_north;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\safr_%shortfilename1%.mpr %UtilDir%\lst_south;


"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\fdslf_africa%shortfilename1%.mpr:=MapGlue('%UtilDir%\lst_whole'.grf,%OutputDrive%\%OutputDir%\nafr_%shortfilename1%,%OutputDrive%\%OutputDir%\safr_%shortfilename1%,replace)

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\LSA_dslf_africa%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\fdslf_africa%shortfilename1% gt 0,%OutputDrive%\%OutputDir%\fdslf_africa%shortfilename1%/10.00,?)



del fdslf_africa%shortfilename1%.*
del *.xml
del nafr_%shortfilename1%.*
del safr_%shortfilename1%.*
del S-LSA_-HDF5_LSASAF_MSG_DSLF_NAfr_*.*
del S-LSA_-HDF5_LSASAF_MSG_DSLF_SAfr_*.*

:END
"%IlwDir%\ilwis.exe" -C closeall