@echo off
echo rem: LAI African continent (unit: m2/m2)
set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
cd\
%OutputDrive%
cd %OutputDir%



echo *%OutputDir%*

copy %InputDrive%\%InputDir%\"S-LSA_-HDF5_LSASAF_MSG_LAI_NAfr_%shortfilename1%.bz2" 
copy %InputDrive%\%InputDir%\"S-LSA_-HDF5_LSASAF_MSG_LAI_SAfr_%shortfilename1%.bz2" 

if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_LAI_NAfr_%shortfilename1%.bz2" goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_LAI_SAfr_%shortfilename1%.bz2" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_LAI_*Afr_%shortfilename1%.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_LAI_NAfr_%shortfilename1%.bz2
"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_LAI_SAfr_%shortfilename1%.bz2


"%gdalDir%\gdal_translate.exe" -of ilwis hdf5:"S-LSA_-HDF5_LSASAF_MSG_LAI_NAfr_%shortfilename1%"://lai "%OutputDrive%\%OutputDir%\nafr_%shortfilename1%"
"%gdalDir%\gdal_translate.exe" -of ilwis hdf5:"S-LSA_-HDF5_LSASAF_MSG_LAI_SAfr_%shortfilename1%"://lai "%OutputDrive%\%OutputDir%\safr_%shortfilename1%"


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\nafr_%shortfilename1%.mpr %UtilDir%\lst_north;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\safr_%shortfilename1%.mpr %UtilDir%\lst_south;


"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\flai_africa%shortfilename1%.mpr:=MapGlue('%UtilDir%\lst_whole'.grf,%OutputDrive%\%OutputDir%\nafr_%shortfilename1%,%OutputDrive%\%OutputDir%\safr_%shortfilename1%,replace)

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\LSA_lai_africa%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\flai_africa%shortfilename1% ge 0,%OutputDrive%\%OutputDir%\flai_africa%shortfilename1%/1000,?)



del flai_africa*.mp*
del *.xml
del nafr_%shortfilename1%.*
del safr_%shortfilename1%.*
del S-LSA_-HDF5_LSASAF_MSG_LAI_*.*



:END
"%IlwDir%\ilwis.exe" -C closeall