@echo off
echo HSAF MPEG-import
echo temporal resolution daily
echo rainfall of previous day as from hhmm time stamp
echo Output is a value map in mm/day 
echo file name expected is S-HSAF-h90_20230322_1800_24_fdk.nc.gz




set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%




copy "%InputDrive%\%InputDir%\S-HSAF-h90_%shortfilename1%_%shortfilename2%_24_fdk.nc.gz" 


if not exist "%InputDrive%\%InputDir%\S-HSAF-h90_%shortfilename1%_%shortfilename2%_24_fdk.nc.gz"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-HSAF-h90_%shortfilename1%_%shortfilename2%_24_fdk.nc.gz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%_%shortfilename2%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-HSAF-h90_%shortfilename1%_%shortfilename2%_24_fdk.nc.gz

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"h90_%shortfilename1%_%shortfilename2%_24_fdk.nc"://acc_rr "%OutputDrive%\%OutputDir%\acc_rr.mpr"

"%IlwDir%\ilwis.exe" -C mv:=MapMirrorRotate(acc_rr,MirrVert)
"%IlwDir%\ilwis.exe" -C mvh:=MapMirrorRotate(mv,MirrHor)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\h90bd_%shortfilename1%%shortfilename2%_24'.mpr:=iff('%OutputDrive%\%OutputDir%\mvh'gt 0.005,'%OutputDrive%\%OutputDir%\mvh',?)
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\h90bd_%shortfilename1%%shortfilename2%_24'.mpr '%UtilDir%\msg2_IODC'


del acc_rr.*
del mv.*
del mvh.*
del h90_%shortfilename1%_%shortfilename2%_24_fdk.*
del S-HSAF-h90_%shortfilename1%_%shortfilename2%_24_fdk.*

:END
"%IlwDir%\ilwis.exe" -C closeall