@echo off
echo HSAF Precipitation/Soil Moisture integrated product
echo Gridded daily precipitation - accumulated_precipitation_(combined_SM-PMW)_estimate
echo The product provides the rainfall fallen the day before the date of the product time stamp - e.g. previous day 
echo Output is a value map in mm/day 
echo file name expected is S-HSAF-h64_20230321_0000_24_hea.nc.gz




set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%




copy "%InputDrive%\%InputDir%\S-HSAF-h64_%shortfilename1%_0000_24_hea.nc.gz" 


if not exist "%InputDrive%\%InputDir%\S-HSAF-h64_%shortfilename1%_0000_24_hea.nc.gz"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-HSAF-h64_%shortfilename1%_0000_24_hea.nc.gz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-HSAF-h64_%shortfilename1%_0000_24_hea.nc.gz

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"h64_%shortfilename1%_0000_24_hea.nc"://acc_rr "%OutputDrive%\%OutputDir%\acc_rr.mpr"

"%IlwDir%\ilwis.exe" -C h64_acc_rr_%shortfilename1%_24:=MapMirrorRotate(acc_rr,MirrHor)
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\h64_acc_rr_%shortfilename1%_24'.mpr '%UtilDir%\h64'


del acc_rr.*
del S-HSAF-h64_%shortfilename1%_0000_24_hea.*
del h64_%shortfilename1%_0000_24_hea.*

:END
"%IlwDir%\ilwis.exe" -C closeall