@echo off
echo HSAF MPEG-import
echo temporal resolution hour
echo Output is a value map in mm/hr 
echo file name expected is S-HSAF-h61_20220630_1700_01_fdk.nc.gz




set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%




copy "%InputDrive%\%InputDir%\S-HSAF-h61_%shortfilename1%_%shortfilename2%_01_fdk.nc.gz" 


if not exist "%InputDrive%\%InputDir%\S-HSAF-h61_%shortfilename1%_%shortfilename2%_01_fdk.nc.gz"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-HSAF-h61_%shortfilename1%_%shortfilename2%_01_fdk.nc.gz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-HSAF-h61_%shortfilename1%_%shortfilename2%_01_fdk.nc.gz

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"h61_%shortfilename1%_%shortfilename2%_01_fdk.nc"://acc_rr "%OutputDrive%\%OutputDir%\acc_rr.mpr"

"%IlwDir%\ilwis.exe" -C mv:=MapMirrorRotate(acc_rr,MirrVert)
"%IlwDir%\ilwis.exe" -C mvh:=MapMirrorRotate(mv,MirrHor)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\h61bh_%shortfilename1%%shortfilename2%'.mpr:=iff('%OutputDrive%\%OutputDir%\mvh'gt 0.005,'%OutputDrive%\%OutputDir%\mvh',?)
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\h61bh_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\msg_0degree_3km'


del acc_rr.*
del mv.*
del mvh.*
del h61_%shortfilename1%_%shortfilename2%_01_fdk.*
del S-HSAF-h61_%shortfilename1%_%shortfilename2%_01_fdk.*

:END
"%IlwDir%\ilwis.exe" -C closeall