@echo off

rem Himawari-8 import
rem 10 blocks are required - of 550 lines and 5500 columns each
rem all can have different header size
rem java application ReadHimawariHeader.java and ReadHimawariHeader.class are used to read header size
rem data blocks are imported in ilwis, with known header size for each block
rem subsequently all data blocks are merged into temporary single file
rem dummy mpr is used 
rem finally coordinate and georeference info is assigned
rem file name convention is IMG_DK01VIS_201701270000_001.bz2 for VIS band only
rem file name convention is IMG_DK01IR1_201701270000_001.bz2 to IMG_DK01IR4_201701271305_006.bz2, for bands IR1, IR2, IR3 and IR4
rem file name convention is IMG_DK01B04_201701270000_001.bz2 to IMG_DK01B16_201701270000_001.bz2, for bands 04, 05, 06, 09, 10, 11, 14, 16




set longfilename=%1
set shortfilename1=%longfilename:~0,16%
set shortfilename2=%longfilename:~0,11%
set shortfilename3=%longfilename:~12,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*
echo import IR1-IR4 images

copy "%InputDrive%\%InputDir%\IMG_DK01IR?_%shortfilename2%?_0??.bz2

if not exist "%OutputDrive%\%OutputDir%\IMG_DK01IR1_%shortfilename2%?_001.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\IMG_DK01IR_%shortfilename2%?_0??.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

rem ===========================IR1-start==========================

"%UtilDir%\7z.exe" e IMG_DK01IR1_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo IR1 channel - band 13 is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=10.4
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	298.54194
echo b =	0.18897469
echo c =	-0.0048762071
echo d =	3.9605919e-005
echo e =	-1.5915753e-007
echo f =	3.4826914e-010
echo g =	-4.2303896e-013
echo h =	2.6792457e-016
echo i =	-6.9017079e-020

rem read header size and import block

rem for block1
rename IMG_DK01IR1_%shortfilename2%?_001 IMG_DK01IR1_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01IR1_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01IR1_%shortfilename2%?_002 IMG_DK01IR1_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01IR1_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01IR1_%shortfilename2%?_003 IMG_DK01IR1_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01IR1_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block4
rename IMG_DK01IR1_%shortfilename2%?_004 IMG_DK01IR1_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01IR1_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01IR1_%shortfilename2%?_005 IMG_DK01IR1_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01IR1_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01IR1_%shortfilename2%?_006 IMG_DK01IR1_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01IR1_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01IR1_%shortfilename2%?_007 IMG_DK01IR1_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01IR1_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01IR1_%shortfilename2%?_008 IMG_DK01IR1_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01IR1_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01IR1_%shortfilename2%?_009 IMG_DK01IR1_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01IR1_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01IR1_%shortfilename2%?_010 IMG_DK01IR1_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01IR1_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01IR1_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# IR1t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ IR1t him_8allb.mpr > IR1t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf IR1t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_IR1_B13'.mpr{dom=value;vr=130.000:330.000:0.001}:=328.14961+0.14102775*IR1t+-0.0044289249*POW(IR1t,2)+3.5208312e-005*POW(IR1t,3)+-1.4031225e-007*POW(IR1t,4)+3.0609706e-010*POW(IR1t,5)+-3.7182077e-013*POW(IR1t,6)+2.3592793e-016*POW(IR1t,7)+-6.0968631e-020*POW(IR1t,8)



rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01IR1_%shortfilename2%?_0??.*
del block??.mp*`
del IR1t.mp*
rem =================================IR1-End===================================


rem ===========================IR2-start==========================

"%UtilDir%\7z.exe" e IMG_DK01IR2_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo IR2 channel - band 15 is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=12.3
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	328.69185
echo b =	0.055575398
echo c =	-0.0029333156
echo d =	2.3303753e-005
echo e =	-9.3286602e-008
echo f =	2.0456632e-010
echo g =	-2.4992302e-013
echo h =	1.5955306e-016
echo i =	-4.1503255e-020

rem read header size and import block

rem for block1
rename IMG_DK01IR2_%shortfilename2%?_001 IMG_DK01IR2_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01IR2_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01IR2_%shortfilename2%?_002 IMG_DK01IR2_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01IR2_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01IR2_%shortfilename2%?_003 IMG_DK01IR2_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01IR2_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01IR2_%shortfilename2%?_004 IMG_DK01IR2_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01IR2_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01IR2_%shortfilename2%?_005 IMG_DK01IR2_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01IR2_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01IR2_%shortfilename2%?_006 IMG_DK01IR2_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01IR2_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01IR2_%shortfilename2%?_007 IMG_DK01IR2_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01IR2_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01IR2_%shortfilename2%?_008 IMG_DK01IR2_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01IR2_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01IR2_%shortfilename2%?_009 IMG_DK01IR2_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01IR2_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01IR2_%shortfilename2%?_010 IMG_DK01IR2_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01IR2_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01IR2_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# IR2t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ IR2t him_8allb.mpr > IR2t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf IR2t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_IR2_B15'.mpr{dom=value;vr=130.000:330.000:0.001}:=328.69185+0.055575398*IR2t+-0.0029333156*POW(IR2t,2)+2.3303753e-005*POW(IR2t,3)+-9.3286602e-008*POW(IR2t,4)+2.0456632e-010*POW(IR2t,5)+-2.4992302e-013*POW(IR2t,6)+1.5955306e-016*POW(IR2t,7)+-4.1503255e-020*POW(IR2t,8)


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01IR2_%shortfilename2%?_0??.*
del block??.mp*
del IR2t.mp*
rem =================================IR2-End===================================

rem ===========================IR3-start==========================

"%UtilDir%\7z.exe" e IMG_DK01IR3_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo IR3 channel - band 08 is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=6.2
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	298.54194
echo b =	0.18897469
echo c =	-0.0048762071
echo d =	3.9605919e-005
echo e =	-1.5915753e-007
echo f =	3.4826914e-010
echo g =	-4.2303896e-013
echo h =	2.6792457e-016
echo i =	-6.9017079e-020

rem read header size and import block

rem for block1
rename IMG_DK01IR3_%shortfilename2%?_001 IMG_DK01IR3_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01IR3_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01IR3_%shortfilename2%?_002 IMG_DK01IR3_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01IR3_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01IR3_%shortfilename2%?_003 IMG_DK01IR3_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01IR3_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01IR3_%shortfilename2%?_004 IMG_DK01IR3_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01IR3_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01IR3_%shortfilename2%?_005 IMG_DK01IR3_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01IR3_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01IR3_%shortfilename2%?_006 IMG_DK01IR3_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01IR3_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01IR3_%shortfilename2%?_007 IMG_DK01IR3_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01IR3_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01IR3_%shortfilename2%?_008 IMG_DK01IR3_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01IR3_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01IR3_%shortfilename2%?_009 IMG_DK01IR3_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01IR3_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01IR3_%shortfilename2%?_010 IMG_DK01IR3_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01IR3_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01IR3_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# IR3t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ IR3t him_8allb.mpr > IR3t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf IR3t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_IR3_B08'.mpr{dom=value;vr=130.000:330.000:0.001}:=298.54194+0.18897469*IR3t+-0.0048762071*POW(IR3t,2)+3.9605919e-005*POW(IR3t,3)+-1.5915753e-007*POW(IR3t,4)+3.4826914e-010*POW(IR3t,5)+-4.2303896e-013*POW(IR3t,6)+2.6792457e-016*POW(IR3t,7)+-6.9017079e-020*POW(IR3t,8)


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01IR3_%shortfilename2%?_0??.*
del block??.mp*
del IR3t.mp*
rem =================================IR3-End===================================

rem ===========================IR4-start==========================

"%UtilDir%\7z.exe" e IMG_DK01IR4_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo IR4 channel - band 07 is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=3.9
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	318.63457
echo b =	0.18913895
echo c =	-0.0046799724
echo d =	3.8333158e-005
echo e =	-1.5506635e-007
echo f =	3.4114604e-010
echo g =	-4.161181e-013
echo h =	2.6436782e-016
echo i =	-6.8252506e-020

rem read header size and import block

rem for block1
rename IMG_DK01IR4_%shortfilename2%?_001 IMG_DK01IR4_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01IR4_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01IR4_%shortfilename2%?_002 IMG_DK01IR4_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01IR4_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01IR4_%shortfilename2%?_003 IMG_DK01IR4_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01IR4_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01IR4_%shortfilename2%?_004 IMG_DK01IR4_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01IR4_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01IR4_%shortfilename2%?_005 IMG_DK01IR4_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01IR4_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01IR4_%shortfilename2%?_006 IMG_DK01IR4_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01IR4_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01IR4_%shortfilename2%?_007 IMG_DK01IR4_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01IR4_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01IR4_%shortfilename2%?_008 IMG_DK01IR4_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01IR4_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01IR4_%shortfilename2%?_009 IMG_DK01IR4_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01IR4_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01IR4_%shortfilename2%?_010 IMG_DK01IR4_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01IR4_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01IR4_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# IR4t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ IR4t him_8allb.mpr > IR4t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf IR4t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_IR4_B07'.mpr{dom=value;vr=130.000:330.000:0.001}:=318.63457+0.18913895*IR4t+-0.0046799724*POW(IR4t,2)+3.8333158e-005*POW(IR4t,3)+-1.5506635e-007*POW(IR4t,4)+3.4114604e-010*POW(IR4t,5)+-4.161181e-013*POW(IR4t,6)+2.6436782e-016*POW(IR4t,7)+-6.8252506e-020*POW(IR4t,8)


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01IR4_%shortfilename2%?_0??.*
del block??.mp*
del IR4t.mp*
rem =================================IR4-End===================================

:END
"%IlwDir%\ilwis.exe" -C closeall