import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.Border;


public class LogWindow {
	
	private final Frame mainWindow;
	private JDialog messagesLogWindow;
	private JTextArea textBox;
	private final DateFormat df;
	
	public LogWindow(Frame mainWindow) {
		this.mainWindow = mainWindow;
		this.messagesLogWindow = null;
		this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	}

	public void log(String message, boolean attention) {
		ensureLogWindowShowing(attention);
		Calendar calendar = new GregorianCalendar();
		textBox.append(df.format(calendar.getTime()) + ": " + message + "\n");
		textBox.setCaretPosition(textBox.getText().length());
	}

	private void ensureLogWindowShowing(boolean attention) {
		// create
		if (messagesLogWindow == null)
			messagesLogWindow = createUI(); // delay creating the UI til there's need for it
		if (attention) {
			// show
			if (!messagesLogWindow.isVisible()) {
				placeLogWindow();
				messagesLogWindow.setVisible(true);
			}
		}
	}
	
	public void ensureLogWindowShowing() {
		ensureLogWindowShowing(true);
	}

	private JDialog createUI() {
		JDialog messages = new JDialog(mainWindow, mainWindow.getTitle() + " Messages");
		textBox = new JTextArea();		
		textBox.setEditable(false);
		textBox.setForeground(Color.BLUE);
		textBox.setBackground(new Color(245, 245, 245));
		Font font = new Font("Monospaced", Font.PLAIN, 12);
		textBox.setFont(font);
		JScrollPane scrollPane = new JScrollPane(textBox, ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		Border border = BorderFactory.createRaisedBevelBorder();
		scrollPane.setBorder(border);
		messages.add(scrollPane);
		return messages;
	}
	
	private void placeLogWindow() {
		Rectangle bounds = mainWindow.getBounds();
		bounds.translate(0, bounds.height);
		bounds.setSize(bounds.width, bounds.height / 4);
		messagesLogWindow.setBounds(bounds);
	}

	public void parentMoved() {
		if (messagesLogWindow != null) {
			Rectangle parentBounds = mainWindow.getBounds();
			Rectangle myBounds = messagesLogWindow.getBounds();
			if (Math.abs(parentBounds.x - myBounds.x) < 40 && Math.abs(parentBounds.y + parentBounds.height - myBounds.y) < 40) {
				parentBounds.translate(0, parentBounds.height);
				parentBounds.setSize(myBounds.getSize());
				messagesLogWindow.setBounds(parentBounds);
			}
		}
	}
}
