import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class FileProcessor implements Runnable {

	private final List<ActionListener> listeners;

	private boolean abort;

	private final GeneralConfig data;

	private final LogWindow log;

	public FileProcessor(GeneralConfig data, LogWindow log) {
		this.data = data;
		this.log = log;
		abort = false;
		listeners = new ArrayList<ActionListener>();
		new Thread(this).start();
	}

	public void abort() {
		abort = true;
	}

	public void addActionListener(ActionListener listener) {
		listeners.add(listener);
	}

	public void run() {
		String msg = "Ready";
		try {
			processFiles();
		} catch (Exception e) {
			msg = e.getMessage();
		}
		if (listeners != null) {
			for (ActionListener listener : listeners)
				listener.actionPerformed(new ActionEvent(this, 0, msg));
		}
	}

	public void processFiles() {
		Object synchronizer = new Object();
		while (!abort) {

			// per sensor, collect list of files to move from source to output folder
			// process these files (move from source to output folder, or delete directly)
			// log any missing files from output folder
			try {
				data.processFiles();
			} catch (Exception e) {
				log.log(e.getMessage(), true);
			}

			// per sensor, collect list of files to delete from output folder (all files older than ONE_WEEK, TWO_WEEKS etc.)

			// delete these files from output folder

			// Take care to delete empty folders from output
			synchronized (synchronizer) {
				try {
					for (int i = 0; (i < 30) && (!abort); ++i)
						synchronizer.wait(1000);
				} catch (InterruptedException e) {
				} finally {
				}
			}

		}
	}

	public static boolean copyFile(File sourceFile, File destinationFile) {
		boolean success = true;
		try {
			if (!destinationFile.exists())
				destinationFile.createNewFile();
	
			FileChannel source = null;
			FileChannel destination = null;
			try {
				source = new FileInputStream(sourceFile).getChannel();
				destination = new FileOutputStream(destinationFile).getChannel();
				long count = 0;
				long size = source.size();
				while (count < size)
					count += destination.transferFrom(source, count, size - count);
			} catch (IOException e) {
				success = false;
			} finally {
				if (source != null)
					source.close();
				if (destination != null)
					destination.close();
			}
		} catch (IOException e) {
			success = false;			
		}
		return success;
	}

	// public static boolean delete(File resource) throws IOException {
	// if (resource.isDirectory()) {
	// File[] childFiles = resource.listFiles();
	// for (File child : childFiles)
	// delete(child);
	//
	// }
	// return resource.delete();
	// }
}
