import java.io.File;

import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class CycleMonitor {

	private JProgressBar progressBar;
	private JTextField currentCycleText;
	
	private int pos;
	private String currentCycle;
	private RolloverQueue recentFiles;


	public CycleMonitor(JProgressBar progressBar, JTextField currentCycleText, int maxCycleElements) {
		this.progressBar = progressBar;
		this.currentCycleText = currentCycleText;
		this.recentFiles = new RolloverQueue(maxCycleElements);
		
		this.pos = 0;
		if (progressBar != null) {
			this.progressBar.setMinimum(0);
			this.progressBar.setMaximum(maxCycleElements - 1);
			this.progressBar.setValue(pos);
		}
		
		this.currentCycle = "";
	}

	public void reportFile(File file, DateUtils du) {
		String cycle = du.getCycle(file);
		if (currentCycle != null && currentCycle.length() > 0) {
			int cmp = cycle.compareTo(currentCycle);
			if (cmp > 0) {
				if (recentFiles.addNew(file)) {
					pos = 0;
					if (progressBar != null)
						progressBar.setValue(pos);		
					// commit cycle increase
					currentCycle = cycle;
					currentCycleText.setText(currentCycle);
				}
			} else if (cmp == 0) {
				if (recentFiles.addNew(file)) {
					++pos;
					if (progressBar != null)
						progressBar.setValue(pos);
				}
			}
		} else  {// first time
			++pos;
			currentCycle = cycle;
			currentCycleText.setText(currentCycle);
			if (progressBar != null) {
				progressBar.setStringPainted(true);
				progressBar.setValue(pos);
			}
		}
	}
}
