/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import org.n52.operation.cropmodeling.AttributeData;
import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.TimeTemperature;

public class DayWeatherData
extends AttributeData {
    protected JulianTime time;

    double getDailyAverageTemperature() {
        double dayLength = this.time.getDayLength();
        double tMid = (this.getAttributeData("TMax") + this.getAttributeData("TMin")) / 2.0;
        double ampl = (this.getAttributeData("TMax") - this.getAttributeData("TMin")) / 2.0;
        double sunrise = 12.0 - dayLength / 2.0;
        double sunset = 12.0 + dayLength / 2.0;
        double aux = Math.PI * (sunset - this.time.getMiddayToday().getYearHours()) / (sunrise + 10.0);
        double tDay = tMid + (sunset - this.time.getMiddayToday().getYearHours()) * ampl * Math.sin(aux) / (dayLength * aux);
        double tNight = tMid - ampl * Math.sin(aux) / (Math.PI - aux);
        double t24h = (tDay * dayLength + tNight * (24.0 - dayLength)) / 24.0;
        return t24h;
    }

    double getDayTimeTemperature() {
        double dayLength = this.time.getDayLength();
        double tMid = (this.getAttributeData("TMax") + this.getAttributeData("TMin")) / 2.0;
        double ampl = (this.getAttributeData("TMax") - this.getAttributeData("TMin")) / 2.0;
        double sunrise = 12.0 - dayLength / 2.0;
        double sunset = 12.0 + dayLength / 2.0;
        double aux = Math.PI * (sunset - this.time.getMiddayToday().getYearHours()) / (sunrise + 24.0 - this.time.getMiddayToday().getYearHours());
        return tMid + (sunset - this.time.getMiddayToday().getYearHours()) * ampl * Math.sin(aux) / (dayLength * aux);
    }

    TimeTemperature[] getTemperatures(int gridNr) {
        return null;
    }

    JulianTime getTime() {
        return this.time;
    }

    public void setTime(JulianTime time) {
        this.time = time;
    }
}

