/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import thredds.inventory.TimedCollection;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class CompositePointCollection
extends PointCollectionImpl
implements UpdateableCollection {
    private TimedCollection pointCollections;
    protected List<VariableSimpleIF> dataVariables;
    protected List<Attribute> globalAttributes;

    protected CompositePointCollection(String name, CalendarDateUnit timeUnit, String altUnits, TimedCollection pointCollections) throws IOException {
        super(name, timeUnit, altUnits);
        this.pointCollections = pointCollections;
    }

    private void readMetadata() {
        TimedCollection.Dataset td = this.pointCollections.getPrototype();
        if (td == null) {
            throw new RuntimeException("No datasets in the collection");
        }
        Formatter errlog = new Formatter();
        try (FeatureDatasetPoint openDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.POINT, td.getLocation(), null, errlog);){
            if (openDataset != null) {
                this.dataVariables = openDataset.getDataVariables();
                this.globalAttributes = openDataset.getGlobalAttributes();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public List<VariableSimpleIF> getDataVariables() {
        if (this.dataVariables == null) {
            this.readMetadata();
        }
        return this.dataVariables;
    }

    public List<Attribute> getGlobalAttributes() {
        if (this.globalAttributes == null) {
            this.readMetadata();
        }
        return this.globalAttributes;
    }

    @Override
    @Nonnull
    public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        if (dateRange == null && boundingBox == null) {
            return this;
        }
        if (dateRange == null) {
            return new PointCollectionImpl.PointCollectionSubset(this, boundingBox, null);
        }
        CompositePointCollection dateSubset = new CompositePointCollection(this.name, this.getTimeUnit(), this.getAltUnits(), this.pointCollections.subset(dateRange));
        return new PointCollectionImpl.PointCollectionSubset(dateSubset, boundingBox, dateRange);
    }

    @Override
    public PointFeatureIterator getPointFeatureIterator() throws IOException {
        return new CompositePointFeatureIterator();
    }

    @Override
    public CalendarDateRange update() throws IOException {
        return this.pointCollections.update();
    }

    private class CompositePointFeatureIterator
    extends PointIteratorAbstract {
        private boolean finished = false;
        private Iterator<TimedCollection.Dataset> iter;
        private FeatureDatasetPoint currentDataset;
        private PointFeatureIterator pfIter = null;

        CompositePointFeatureIterator() {
            this.iter = CompositePointCollection.this.pointCollections.getDatasets().iterator();
        }

        private PointFeatureIterator getNextIterator() throws IOException {
            if (!this.iter.hasNext()) {
                return null;
            }
            TimedCollection.Dataset td = this.iter.next();
            Formatter errlog = new Formatter();
            this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.POINT, td.getLocation(), null, errlog);
            if (this.currentDataset == null) {
                throw new IllegalStateException("Cant open FeatureDatasetPoint " + td.getLocation());
            }
            if (CompositeDatasetFactory.debug) {
                System.out.printf("CompositePointFeatureIterator open dataset %s%n", td.getLocation());
            }
            List<DsgFeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
            PointFeatureCollection pc = (PointFeatureCollection)fcList.get(0);
            return pc.getPointFeatureIterator();
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.pfIter == null) {
                    this.pfIter = this.getNextIterator();
                    if (this.pfIter == null) {
                        this.close();
                        return false;
                    }
                }
                if (!this.pfIter.hasNext()) {
                    this.pfIter.close();
                    if (CompositeDatasetFactory.debug) {
                        System.out.printf("CompositePointFeatureIterator open dataset %s%n", this.currentDataset.getLocation());
                    }
                    this.currentDataset.close();
                    this.pfIter = this.getNextIterator();
                    return this.hasNext();
                }
                return true;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public PointFeature next() {
            return this.pfIter.next();
        }

        @Override
        public void close() {
            if (this.finished) {
                return;
            }
            if (this.pfIter != null) {
                this.pfIter.close();
            }
            this.finishCalcBounds();
            if (this.currentDataset != null) {
                try {
                    this.currentDataset.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.finished = true;
        }
    }
}

