/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.EnhanceScaleMissingUnsigned;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.util.Misc;

class EnhanceScaleMissingUnsignedImpl
implements EnhanceScaleMissingUnsigned {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DataType origDataType = null;
    private DataType unsignedConversionType = null;
    private DataType scaledOffsetType = null;
    private boolean invalidDataIsMissing = NetcdfDataset.invalidDataIsMissing;
    private boolean fillValueIsMissing = NetcdfDataset.fillValueIsMissing;
    private boolean missingDataIsMissing = NetcdfDataset.missingDataIsMissing;
    private boolean hasScaleOffset = false;
    private double scale = 1.0;
    private double offset = 0.0;
    private boolean hasValidRange = false;
    private boolean hasValidMin = false;
    private boolean hasValidMax = false;
    private double validMin = -1.7976931348623157E308;
    private double validMax = Double.MAX_VALUE;
    private boolean hasFillValue = false;
    private double fillValue;
    private boolean hasMissingValue = false;
    private double[] missingValue;
    private DataType.Signedness signedness;

    EnhanceScaleMissingUnsignedImpl() {
    }

    EnhanceScaleMissingUnsignedImpl(VariableDS forVar) {
        this(forVar, NetcdfDataset.fillValueIsMissing, NetcdfDataset.invalidDataIsMissing, NetcdfDataset.missingDataIsMissing);
    }

    private EnhanceScaleMissingUnsignedImpl(VariableDS forVar, boolean fillValueIsMissing, boolean invalidDataIsMissing, boolean missingDataIsMissing) {
        Attribute fillValueAtt;
        Attribute validRangeAtt;
        Attribute offsetAtt;
        Attribute unsignedAtt;
        this.fillValueIsMissing = fillValueIsMissing;
        this.invalidDataIsMissing = invalidDataIsMissing;
        this.missingDataIsMissing = missingDataIsMissing;
        this.unsignedConversionType = this.origDataType = forVar.getDataType();
        this.signedness = this.origDataType.getSignedness();
        if (this.signedness == DataType.Signedness.SIGNED && (unsignedAtt = forVar.findAttributeIgnoreCase("_Unsigned")) != null && unsignedAtt.getStringValue().equalsIgnoreCase("true")) {
            this.signedness = DataType.Signedness.UNSIGNED;
        }
        if (this.signedness == DataType.Signedness.UNSIGNED) {
            this.unsignedConversionType = EnhanceScaleMissingUnsignedImpl.nextLarger(this.origDataType).withSignedness(DataType.Signedness.UNSIGNED);
            logger.debug("assign unsignedConversionType = {}", (Object)this.unsignedConversionType);
        }
        DataType scaleType = null;
        DataType offsetType = null;
        DataType validType = null;
        logger.debug("{} for Variable = {}", (Object)this.getClass().getSimpleName(), (Object)forVar.getFullName());
        Attribute scaleAtt = forVar.findAttribute("scale_factor");
        if (scaleAtt != null && !scaleAtt.isString()) {
            scaleType = this.getAttributeDataType(scaleAtt);
            this.scale = EnhanceScaleMissingUnsignedImpl.convertUnsigned(scaleAtt.getNumericValue(), scaleType).doubleValue();
            this.hasScaleOffset = true;
            logger.debug("scale = {}    type = {}", (Object)this.scale, (Object)scaleType);
        }
        if ((offsetAtt = forVar.findAttribute("add_offset")) != null && !offsetAtt.isString()) {
            offsetType = this.getAttributeDataType(offsetAtt);
            this.offset = EnhanceScaleMissingUnsignedImpl.convertUnsigned(offsetAtt.getNumericValue(), offsetType).doubleValue();
            this.hasScaleOffset = true;
            logger.debug("offset = {}", (Object)this.offset);
        }
        if ((validRangeAtt = forVar.findAttribute("valid_range")) != null && !validRangeAtt.isString() && validRangeAtt.getLength() > 1) {
            validType = this.getAttributeDataType(validRangeAtt);
            this.validMin = EnhanceScaleMissingUnsignedImpl.convertUnsigned(validRangeAtt.getNumericValue(0), validType).doubleValue();
            this.validMax = EnhanceScaleMissingUnsignedImpl.convertUnsigned(validRangeAtt.getNumericValue(1), validType).doubleValue();
            this.hasValidRange = true;
            logger.debug("valid_range = {}  {}", (Object)this.validMin, (Object)this.validMax);
        }
        Attribute validMinAtt = forVar.findAttribute("valid_min");
        Attribute validMaxAtt = forVar.findAttribute("valid_max");
        if (!this.hasValidRange) {
            if (validMinAtt != null && !validMinAtt.isString()) {
                validType = this.getAttributeDataType(validMinAtt);
                this.validMin = EnhanceScaleMissingUnsignedImpl.convertUnsigned(validMinAtt.getNumericValue(), validType).doubleValue();
                this.hasValidMin = true;
                logger.debug("valid_min = {}", (Object)this.validMin);
            }
            if (validMaxAtt != null && !validMaxAtt.isString()) {
                validType = EnhanceScaleMissingUnsignedImpl.largestOf(validType, this.getAttributeDataType(validMaxAtt));
                this.validMax = EnhanceScaleMissingUnsignedImpl.convertUnsigned(validMaxAtt.getNumericValue(), validType).doubleValue();
                this.hasValidMax = true;
                logger.debug("valid_min = {}", (Object)this.validMax);
            }
            if (this.hasValidMin && this.hasValidMax) {
                this.hasValidRange = true;
            }
        }
        if ((fillValueAtt = forVar.findAttribute("_FillValue")) != null && !fillValueAtt.isString()) {
            DataType fillType = this.getAttributeDataType(fillValueAtt);
            this.fillValue = EnhanceScaleMissingUnsignedImpl.convertUnsigned(fillValueAtt.getNumericValue(), fillType).doubleValue();
            this.fillValue = this.applyScaleOffset(this.fillValue);
            this.hasFillValue = true;
        } else {
            boolean isNetcdfIosp;
            String fileTypeId = forVar.getNetcdfFile() == null ? null : forVar.getNetcdfFile().getFileTypeId();
            boolean bl = isNetcdfIosp = DataFormatType.NETCDF.getDescription().equals(fileTypeId) || DataFormatType.NETCDF4.getDescription().equals(fileTypeId);
            if (isNetcdfIosp && this.unsignedConversionType.isNumeric()) {
                this.fillValue = this.applyScaleOffset(N3iosp.getFillValueDefault(this.unsignedConversionType));
                this.hasFillValue = true;
            }
        }
        Attribute missingValueAtt = forVar.findAttribute("missing_value");
        if (missingValueAtt != null) {
            if (missingValueAtt.isString()) {
                String svalue = missingValueAtt.getStringValue();
                if (this.origDataType == DataType.CHAR) {
                    this.missingValue = new double[1];
                    this.missingValue[0] = svalue.length() == 0 ? 0.0 : (double)svalue.charAt(0);
                    this.hasMissingValue = true;
                } else {
                    try {
                        this.missingValue = new double[1];
                        this.missingValue[0] = Double.parseDouble(svalue);
                        this.hasMissingValue = true;
                    }
                    catch (NumberFormatException ex) {
                        logger.debug("String missing_value not parseable as double = {}", (Object)missingValueAtt.getStringValue());
                    }
                }
            } else {
                DataType missType = this.getAttributeDataType(missingValueAtt);
                this.missingValue = new double[missingValueAtt.getLength()];
                for (int i = 0; i < this.missingValue.length; ++i) {
                    this.missingValue[i] = EnhanceScaleMissingUnsignedImpl.convertUnsigned(missingValueAtt.getNumericValue(i), missType).doubleValue();
                    this.missingValue[i] = this.applyScaleOffset(this.missingValue[i]);
                }
                logger.debug("missing_data: {}", (Object)Arrays.toString(this.missingValue));
                for (double mv : this.missingValue) {
                    if (Double.isNaN(mv)) continue;
                    this.hasMissingValue = true;
                    break;
                }
            }
        }
        if (this.hasScaleOffset) {
            this.scaledOffsetType = EnhanceScaleMissingUnsignedImpl.largestOf(this.unsignedConversionType, scaleType, offsetType).withSignedness(this.signedness);
            logger.debug("assign scaledOffsetType = {}", (Object)this.scaledOffsetType);
            if (this.hasValidData() && (EnhanceScaleMissingUnsignedImpl.rank(validType) != EnhanceScaleMissingUnsignedImpl.rank(EnhanceScaleMissingUnsignedImpl.largestOf(scaleType, offsetType)) || EnhanceScaleMissingUnsignedImpl.rank(validType) <= EnhanceScaleMissingUnsignedImpl.rank(this.unsignedConversionType))) {
                if (this.hasValidRange || this.hasValidMin) {
                    this.validMin = this.applyScaleOffset(this.validMin);
                }
                if (this.hasValidRange || this.hasValidMax) {
                    this.validMax = this.applyScaleOffset(this.validMax);
                }
            }
        }
    }

    private DataType getAttributeDataType(Attribute attribute) {
        DataType dataType = attribute.getDataType();
        if (this.signedness == DataType.Signedness.UNSIGNED) {
            dataType = dataType.withSignedness(this.signedness);
        }
        return dataType;
    }

    public static int rank(DataType dataType) {
        if (dataType == null) {
            return -1;
        }
        switch (dataType) {
            case BYTE: {
                return 0;
            }
            case UBYTE: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case USHORT: {
                return 3;
            }
            case INT: {
                return 4;
            }
            case UINT: {
                return 5;
            }
            case LONG: {
                return 6;
            }
            case ULONG: {
                return 7;
            }
            case FLOAT: {
                return 8;
            }
            case DOUBLE: {
                return 9;
            }
        }
        return -1;
    }

    public static DataType largestOf(DataType ... dataTypes) {
        DataType widest = null;
        for (DataType dataType : dataTypes) {
            if (widest == null) {
                widest = dataType;
                continue;
            }
            if (EnhanceScaleMissingUnsignedImpl.rank(dataType) <= EnhanceScaleMissingUnsignedImpl.rank(widest)) continue;
            widest = dataType;
        }
        return widest;
    }

    public static DataType nextLarger(DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return DataType.SHORT;
            }
            case UBYTE: {
                return DataType.USHORT;
            }
            case SHORT: {
                return DataType.INT;
            }
            case USHORT: {
                return DataType.UINT;
            }
            case INT: {
                return DataType.LONG;
            }
            case UINT: {
                return DataType.ULONG;
            }
            case LONG: {
                return DataType.DOUBLE;
            }
            case ULONG: {
                return DataType.DOUBLE;
            }
        }
        return dataType;
    }

    @Override
    public double getScaleFactor() {
        return this.scale;
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public DataType.Signedness getSignedness() {
        return this.signedness;
    }

    @Override
    public DataType getScaledOffsetType() {
        return this.scaledOffsetType;
    }

    @Override
    @Nonnull
    public DataType getUnsignedConversionType() {
        return this.unsignedConversionType;
    }

    @Override
    public boolean hasValidData() {
        return this.hasValidRange || this.hasValidMin || this.hasValidMax;
    }

    @Override
    public double getValidMin() {
        return this.validMin;
    }

    @Override
    public double getValidMax() {
        return this.validMax;
    }

    @Override
    public boolean isInvalidData(double val) {
        boolean greaterThanOrEqualToValidMin = Misc.nearlyEquals(val, this.validMin, (double)1.0E-5f) || val > this.validMin;
        boolean lessThanOrEqualToValidMax = Misc.nearlyEquals(val, this.validMax, (double)1.0E-5f) || val < this.validMax;
        return this.hasValidRange && (!greaterThanOrEqualToValidMin || !lessThanOrEqualToValidMax) || this.hasValidMin && !greaterThanOrEqualToValidMin || this.hasValidMax && !lessThanOrEqualToValidMax;
    }

    @Override
    public boolean hasFillValue() {
        return this.hasFillValue;
    }

    @Override
    public boolean isFillValue(double val) {
        return this.hasFillValue && Misc.nearlyEquals(val, this.fillValue, (double)1.0E-5f);
    }

    @Override
    public double getFillValue() {
        return this.fillValue;
    }

    @Override
    public boolean hasScaleOffset() {
        return this.hasScaleOffset;
    }

    @Override
    public boolean hasMissingValue() {
        return this.hasMissingValue;
    }

    @Override
    public boolean isMissingValue(double val) {
        if (!this.hasMissingValue) {
            return false;
        }
        for (double aMissingValue : this.missingValue) {
            if (!Misc.nearlyEquals(val, aMissingValue, (double)1.0E-5f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double[] getMissingValues() {
        return this.missingValue;
    }

    @Override
    public void setFillValueIsMissing(boolean b) {
        this.fillValueIsMissing = b;
    }

    @Override
    public void setInvalidDataIsMissing(boolean b) {
        this.invalidDataIsMissing = b;
    }

    @Override
    public void setMissingDataIsMissing(boolean b) {
        this.missingDataIsMissing = b;
    }

    @Override
    public boolean hasMissing() {
        return this.invalidDataIsMissing && this.hasValidData() || this.fillValueIsMissing && this.hasFillValue() || this.missingDataIsMissing && this.hasMissingValue();
    }

    @Override
    public boolean isMissing(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        return this.missingDataIsMissing && this.isMissingValue(val) || this.fillValueIsMissing && this.isFillValue(val) || this.invalidDataIsMissing && this.isInvalidData(val);
    }

    @Override
    public Number convertUnsigned(Number value) {
        return EnhanceScaleMissingUnsignedImpl.convertUnsigned(value, this.signedness);
    }

    private static Number convertUnsigned(Number value, DataType dataType) {
        return EnhanceScaleMissingUnsignedImpl.convertUnsigned(value, dataType.getSignedness());
    }

    private static Number convertUnsigned(Number value, DataType.Signedness signedness) {
        if (signedness == DataType.Signedness.UNSIGNED) {
            return DataType.widenNumberIfNegative(value);
        }
        return value;
    }

    @Override
    public Array convertUnsigned(Array in) {
        return this.convert(in, true, false, false);
    }

    @Override
    public double applyScaleOffset(Number value) {
        double convertedValue = value.doubleValue();
        return this.hasScaleOffset ? this.scale * convertedValue + this.offset : convertedValue;
    }

    @Override
    public Array applyScaleOffset(Array in) {
        return this.convert(in, false, true, false);
    }

    @Override
    public Number convertMissing(Number value) {
        return this.isMissing(value.doubleValue()) ? (Number)Double.NaN : (Number)value;
    }

    @Override
    public Array convertMissing(Array in) {
        return this.convert(in, false, false, true);
    }

    @Override
    public Array convert(Array in, boolean convertUnsigned, boolean applyScaleOffset, boolean convertMissing) {
        if (!in.getDataType().isNumeric() || !convertUnsigned && !applyScaleOffset && !convertMissing) {
            return in;
        }
        if (this.getSignedness() == DataType.Signedness.SIGNED) {
            convertUnsigned = false;
        }
        if (!this.hasScaleOffset()) {
            applyScaleOffset = false;
        }
        DataType outType = this.origDataType;
        if (convertUnsigned) {
            outType = this.getUnsignedConversionType();
        }
        if (applyScaleOffset) {
            outType = this.getScaledOffsetType();
        }
        if (outType != DataType.FLOAT && outType != DataType.DOUBLE) {
            convertMissing = false;
        }
        Array out = Array.factory(outType, in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        while (iterIn.hasNext()) {
            Number value = (Number)iterIn.getObjectNext();
            if (convertUnsigned) {
                value = this.convertUnsigned(value);
            }
            if (applyScaleOffset) {
                value = this.applyScaleOffset(value);
            }
            if (convertMissing) {
                value = this.convertMissing(value);
            }
            iterOut.setObjectNext(value);
        }
        return out;
    }
}

