/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import gnu.regexp.RETokenChar;
import java.util.Vector;

class RETokenOneOf
extends REToken {
    private Vector options;
    private boolean negative;

    RETokenOneOf(int f_subIndex, String f_options, boolean f_negative, boolean f_insens) {
        super(f_subIndex);
        this.options = new Vector();
        this.negative = f_negative;
        for (int i = 0; i < f_options.length(); ++i) {
            this.options.addElement(new RETokenChar(f_subIndex, f_options.charAt(i), f_insens));
        }
    }

    RETokenOneOf(int f_subIndex, Vector f_options, boolean f_negative) {
        super(f_subIndex);
        this.options = f_options;
        this.negative = f_negative;
    }

    int getMinimumLength() {
        int min2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.options.size(); ++i) {
            int x = ((REToken)this.options.elementAt(i)).getMinimumLength();
            if (x >= min2) continue;
            min2 = x;
        }
        return min2;
    }

    int[] match(CharIndexed input, int index, int eflags, REMatch mymatch) {
        int[] newIndex;
        if (this.negative && input.charAt(index) == '\uffff') {
            return null;
        }
        int[] possibles = new int[]{};
        for (int i = 0; i < this.options.size(); ++i) {
            REToken tk = (REToken)this.options.elementAt(i);
            newIndex = tk.match(input, index, eflags, mymatch);
            if (newIndex == null && tk instanceof RE && tk.m_subIndex > 0) {
                mymatch.reset(tk.m_subIndex + 1);
            }
            if (newIndex == null) continue;
            if (this.negative) {
                return null;
            }
            int[] temp = new int[possibles.length + newIndex.length];
            System.arraycopy(possibles, 0, temp, 0, possibles.length);
            for (int j = 0; j < newIndex.length; ++j) {
                temp[possibles.length + j] = newIndex[j];
            }
            possibles = temp;
        }
        int[] doables = new int[]{};
        for (int i = 0; i < possibles.length; ++i) {
            newIndex = this.next(input, possibles[i], eflags, mymatch);
            if (newIndex != null) {
                int[] temp = new int[doables.length + newIndex.length];
                System.arraycopy(doables, 0, temp, 0, doables.length);
                for (int j = 0; j < newIndex.length; ++j) {
                    temp[doables.length + j] = newIndex[j];
                }
                doables = temp;
                continue;
            }
            if (this.m_subIndex <= 0) continue;
            mymatch.reset(this.m_subIndex + 1);
        }
        if (doables.length > 0) {
            return this.negative ? null : doables;
        }
        return this.negative ? this.next(input, index + 1, eflags, mymatch) : null;
    }

    void dump(StringBuffer os) {
        os.append(this.negative ? "[^" : "(?:");
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.negative && i > 0) {
                os.append('|');
            }
            ((REToken)this.options.elementAt(i)).dumpAll(os);
        }
        os.append(this.negative ? (char)']' : ')');
    }

    boolean chain(REToken f_next) {
        super.chain(f_next);
        for (int i = 0; i < this.options.size(); ++i) {
            ((REToken)this.options.elementAt(i)).setUncle(f_next);
        }
        return true;
    }
}

