/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.utilint.ActiveTxnArrayStat;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.BooleanStat;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongArrayStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StringStat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatGroup {
    private final String groupName;
    private final String groupDescription;
    private final Map<StatDefinition, Stat<?>> stats;

    public StatGroup(String groupName, String groupDescription) {
        this(groupName, groupDescription, new HashMap());
    }

    private StatGroup(String groupName, String groupDescription, Map<StatDefinition, Stat<?>> values) {
        this.groupName = groupName;
        this.groupDescription = groupDescription;
        this.stats = values;
    }

    void register(Stat<?> oneStat) {
        Stat<?> prev = this.stats.put(oneStat.getDefinition(), oneStat);
        assert (prev == null) : "prev = " + prev;
    }

    public void addAll(StatGroup other) {
        for (Map.Entry<StatDefinition, Stat<?>> entry : other.stats.entrySet()) {
            StatDefinition definition = entry.getKey();
            Stat<?> localStat = this.stats.get(definition);
            if (localStat == null) {
                this.stats.put(definition, entry.getValue());
                continue;
            }
            Stat<?> additionalValue = entry.getValue();
            localStat.add(additionalValue);
        }
    }

    public void clear() {
        for (Stat<?> s2 : this.stats.values()) {
            s2.clear();
        }
    }

    public String getName() {
        return this.groupName;
    }

    public String getDescription() {
        return this.groupDescription;
    }

    public StatGroup cloneGroup(boolean clear) {
        HashMap copyValues = new HashMap();
        for (Stat<?> s2 : this.stats.values()) {
            if (clear) {
                copyValues.put(s2.getDefinition(), s2.copyAndClear());
                continue;
            }
            copyValues.put(s2.getDefinition(), s2.copy());
        }
        return new StatGroup(this.groupName, this.groupDescription, copyValues);
    }

    public int getInt(StatDefinition definition) {
        IntStat s2 = (IntStat)this.stats.get(definition);
        if (s2 == null) {
            return 0;
        }
        return s2.get();
    }

    public LongStat getLongStat(StatDefinition definition) {
        return (LongStat)this.stats.get(definition);
    }

    public long getLong(StatDefinition definition) {
        LongStat s2 = this.getLongStat(definition);
        if (s2 == null) {
            return 0L;
        }
        return s2.get();
    }

    public Long getAtomicLong(StatDefinition definition) {
        AtomicLongStat s2 = (AtomicLongStat)this.stats.get(definition);
        if (s2 == null) {
            return 0L;
        }
        return s2.get();
    }

    public TransactionStats.Active[] getActiveTxnArray(StatDefinition definition) {
        ActiveTxnArrayStat s2 = (ActiveTxnArrayStat)this.stats.get(definition);
        if (s2 == null) {
            return null;
        }
        return s2.get();
    }

    public long[] getLongArray(StatDefinition definition) {
        LongArrayStat s2 = (LongArrayStat)this.stats.get(definition);
        if (s2 == null) {
            return null;
        }
        return s2.get();
    }

    public boolean getBoolean(StatDefinition definition) {
        BooleanStat s2 = (BooleanStat)this.stats.get(definition);
        if (s2 == null) {
            return false;
        }
        return s2.get();
    }

    public String getString(StatDefinition definition) {
        StringStat s2 = (StringStat)this.stats.get(definition);
        if (s2 == null) {
            return null;
        }
        return s2.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupName).append(": ");
        sb.append(this.groupDescription).append("\n");
        TreeMap sortedStats = new TreeMap(this.stats);
        for (Stat s2 : sortedStats.values()) {
            sb.append("\t").append(s2).append("\n");
        }
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupName).append(": ");
        sb.append(this.groupDescription).append("\n");
        TreeMap sortedStats = new TreeMap(this.stats);
        for (Stat s2 : sortedStats.values()) {
            sb.append("\t").append(s2.toStringVerbose()).append("\n");
        }
        return sb.toString();
    }
}

