/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.Radiation;
import org.n52.operation.cropmodeling.Weather;
import org.n52.operation.cropmodeling.WeatherData;

public class TemporalEnvironmentState {
    private Weather weather;
    private Radiation radiations;
    private JulianTime time;
    private double timeResolution = 24.0;

    public TemporalEnvironmentState() {
    }

    public TemporalEnvironmentState(String type, WeatherData weatherData, JulianTime time) {
        this.time = time;
        this.weather = Weather.create(type, weatherData);
        this.radiations = new Radiation(this.time, this.weather);
    }

    public TemporalEnvironmentState(String type, WeatherData weatherData, int year, double time) {
        this.time = new JulianTime(weatherData.getLatitude(), year, time);
        this.weather = Weather.create(type, weatherData);
        this.radiations = new Radiation(this.time, this.weather);
    }

    public static TemporalEnvironmentState increment(TemporalEnvironmentState state) {
        state.setTime(JulianTime.add(state.time, 24.0));
        return state;
    }

    public JulianTime getTime() {
        return this.time;
    }

    public void setTime(JulianTime time) {
        this.time.currentJulianTime = time.currentJulianTime;
    }

    public double getTimeResolution() {
        return this.timeResolution;
    }

    public void setTimeResolution(double timeResolution) {
        this.timeResolution = timeResolution;
    }

    public Radiation getCurrentRadiations() {
        return this.radiations;
    }

    public Weather getCurrentWeather() {
        return this.weather;
    }
}

