/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyXmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static SAXBuilder parser_;

    private EasyXmlParser() {
    }

    public static void setParser(String s) {
        block2: {
            try {
                parser_ = s == null ? new SAXBuilder() : new SAXBuilder(new XMLReaderSAX2Factory(false, s));
            }
            catch (Exception exc) {
                LOGGER.warn("Couldn't make SAXBuilder for {}", (Object)s);
                if (!LOGGER.isDebugEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    public static synchronized Document parseDocument(File f) throws FileNotFoundException, IOException, JDOMException {
        Objects.requireNonNull(f, "File cannot be null.");
        if (!f.exists()) {
            throw new IllegalArgumentException("File does not exist");
        }
        if (!f.isFile()) {
            throw new IllegalArgumentException("File is not a file");
        }
        if (parser_ == null) {
            EasyXmlParser.setParser(null);
        }
        return parser_.build(f);
    }

    public static synchronized Document parseDocument(InputStream is) throws FileNotFoundException, IOException, JDOMException {
        Objects.requireNonNull(is, "Input stream cannot be null.");
        if (parser_ == null) {
            EasyXmlParser.setParser(null);
        }
        return parser_.build(is);
    }
}

