/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.ui.table.TableHeaderTheme;
import java.awt.Color;
import java.util.Hashtable;

public class TableTheme {
    private static final Color GRAY_217 = new Color(217, 217, 217);
    private static final Color GRAY_221 = new Color(221, 221, 221);
    private static final Color GRAY_229 = new Color(229, 229, 229);
    private static final Color GRAY_240 = new Color(240, 240, 240);
    private static final Color GRAY_245 = new Color(245, 245, 245);
    private static final Object SINGLETON_LOCK = new Object();
    private static final Color AQUA_BLUE = new Color(237, 243, 254);
    private static final Color PALE_GREEN = new Color(221, 255, 221);
    private static final Color PALE_RED = new Color(255, 221, 221);
    private static final Color PALE_YELLOW = new Color(255, 255, 221);
    private static TableTheme appleYosemiteTheme_;
    private static TableTheme appleAquaTheme_;
    private static TableTheme appleGraphiteTheme_;
    private static TableTheme fanfoldTheme_;
    private static TableTheme fanfoldVTheme_;
    private static TableTheme spreadsheetTheme_;
    private static TableTheme candyStripeTheme_;
    private static TableTheme hudTheme_;
    private Hashtable<ThemeKey, Object> themeProps_ = new Hashtable();

    public TableTheme() {
        this.themeProps_.put(ThemeKey.VERT_GRID_LINES, false);
        this.themeProps_.put(ThemeKey.HORZ_GRID_LINES, false);
        this.themeProps_.put(ThemeKey.BACKGROUND_COLORS, new Color[]{Color.WHITE});
        this.themeProps_.put(ThemeKey.FOREGROUND_COLOR, Color.BLACK);
        this.themeProps_.put(ThemeKey.GRID_COLOR, GRAY_240);
    }

    public TableTheme(Object ... props) {
        this();
        if (props.length % 2 != 0) {
            throw new IllegalArgumentException("Count of properties and keys must be a multiple of 2.");
        }
        for (int i = 0; i < props.length; i += 2) {
            if (props[i] == null) {
                throw new IllegalArgumentException("Property " + i / 2 + " key is null.");
            }
            if (!(props[i] instanceof ThemeKey)) {
                throw new IllegalArgumentException("Property " + i / 2 + " key is not a ThemeKey.");
            }
            if (props[i + 1] == null) {
                throw new IllegalArgumentException("Property " + (Object)((Object)((ThemeKey)((Object)props[i]))) + " cannot be null.");
            }
            this.themeProps_.put((ThemeKey)((Object)props[i]), props[i + 1]);
        }
    }

    public TableHeaderTheme getHeaderTheme() {
        Object o = this.themeProps_.get((Object)ThemeKey.HEADER_THEME);
        if (!(o instanceof TableHeaderTheme)) {
            o = TableHeaderTheme.getOldMacosTheme();
            this.themeProps_.put(ThemeKey.HEADER_THEME, o);
        }
        return (TableHeaderTheme)o;
    }

    public boolean getShowGrid() {
        return this.getShowVerticalLines() || this.getShowHorizontalLines();
    }

    public boolean getShowVerticalLines() {
        Object o = this.themeProps_.get((Object)ThemeKey.VERT_GRID_LINES);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public boolean getShowHorizontalLines() {
        Object o = this.themeProps_.get((Object)ThemeKey.HORZ_GRID_LINES);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public Color getForeground() {
        Object o = this.themeProps_.get((Object)ThemeKey.FOREGROUND_COLOR);
        if (o instanceof Color) {
            return (Color)o;
        }
        return Color.BLACK;
    }

    public Color getBackground(int row) {
        Object o = this.themeProps_.get((Object)ThemeKey.BACKGROUND_COLORS);
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof Color[]) {
            Color[] colors = (Color[])o;
            if (colors.length == 0) {
                return Color.WHITE;
            }
            int index = row % colors.length;
            return colors[index];
        }
        return Color.WHITE;
    }

    public Color getGridColor() {
        Object o = this.themeProps_.get((Object)ThemeKey.GRID_COLOR);
        if (o instanceof Color) {
            return (Color)o;
        }
        return GRAY_240;
    }

    public static TableTheme getMacosYosemiteTheme() {
        if (appleYosemiteTheme_ == null) {
            appleYosemiteTheme_ = new TableTheme(new Object[]{ThemeKey.VERT_GRID_LINES, true, ThemeKey.HORZ_GRID_LINES, false, ThemeKey.GRID_COLOR, GRAY_240, ThemeKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, GRAY_245}, ThemeKey.HEADER_THEME, TableHeaderTheme.getMacosYosemiteTheme()});
        }
        return appleYosemiteTheme_;
    }

    public static TableTheme getMacosGraphiteTheme() {
        if (appleGraphiteTheme_ == null) {
            appleGraphiteTheme_ = new TableTheme(new Object[]{ThemeKey.VERT_GRID_LINES, true, ThemeKey.HORZ_GRID_LINES, false, ThemeKey.GRID_COLOR, GRAY_221, ThemeKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, GRAY_240}, ThemeKey.HEADER_THEME, TableHeaderTheme.getOldMacosTheme()});
        }
        return appleGraphiteTheme_;
    }

    public static TableTheme getMacosAquaTheme() {
        if (appleAquaTheme_ == null) {
            appleAquaTheme_ = new TableTheme(new Object[]{ThemeKey.VERT_GRID_LINES, true, ThemeKey.HORZ_GRID_LINES, false, ThemeKey.GRID_COLOR, GRAY_217, ThemeKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, AQUA_BLUE}, ThemeKey.HEADER_THEME, TableHeaderTheme.getOldMacosTheme()});
        }
        return appleAquaTheme_;
    }

    public static TableTheme getFanfoldTheme() {
        if (fanfoldTheme_ == null) {
            fanfoldTheme_ = new TableTheme(new Object[]{ThemeKey.VERT_GRID_LINES, false, ThemeKey.HORZ_GRID_LINES, false, ThemeKey.GRID_COLOR, null, ThemeKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, PALE_GREEN}});
        }
        return fanfoldTheme_;
    }

    public static TableTheme getFanfoldVTheme() {
        if (fanfoldVTheme_ == null) {
            fanfoldVTheme_ = new TableTheme(new Object[]{ThemeKey.VERT_GRID_LINES, true, ThemeKey.HORZ_GRID_LINES, false, ThemeKey.GRID_COLOR, GRAY_229, ThemeKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, PALE_GREEN}});
        }
        return fanfoldVTheme_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableTheme getSpreadsheetTheme() {
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (spreadsheetTheme_ == null) {
                spreadsheetTheme_ = new TableTheme(new Object[]{ThemeKey.VERT_GRID_LINES, true, ThemeKey.HORZ_GRID_LINES, false, ThemeKey.GRID_COLOR, GRAY_229, ThemeKey.BACKGROUND_COLORS, new Color[]{PALE_YELLOW, PALE_GREEN}});
            }
        }
        return spreadsheetTheme_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableTheme getCandyStripeTheme() {
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (candyStripeTheme_ == null) {
                candyStripeTheme_ = new TableTheme(new Object[]{ThemeKey.VERT_GRID_LINES, false, ThemeKey.HORZ_GRID_LINES, false, ThemeKey.GRID_COLOR, GRAY_229, ThemeKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, PALE_RED}});
            }
        }
        return candyStripeTheme_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableTheme getHudTheme() {
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (hudTheme_ == null) {
                hudTheme_ = new TableTheme(new Object[]{ThemeKey.VERT_GRID_LINES, true, ThemeKey.HORZ_GRID_LINES, false, ThemeKey.GRID_COLOR, Color.GRAY, ThemeKey.BACKGROUND_COLORS, new Color[]{Color.BLACK, Color.DARK_GRAY}, ThemeKey.FOREGROUND_COLOR, Color.WHITE});
            }
        }
        return hudTheme_;
    }

    public static enum ThemeKey {
        VERT_GRID_LINES,
        HORZ_GRID_LINES,
        GRID_COLOR,
        FOREGROUND_COLOR,
        BACKGROUND_COLORS,
        HEADER_THEME;

    }
}

