/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import java.awt.Color;
import java.util.Hashtable;

public class TableHeaderTheme {
    private Hashtable<ThemeKey, Object> themeProps_ = new Hashtable();
    private static final Color GRAY_192 = new Color(192, 192, 192);
    private static final Color GRAY_216 = new Color(216, 216, 216);
    private static final Color GRAY_228 = new Color(228, 228, 228);
    private static final Color GRAY_240 = new Color(240, 240, 240);
    private static TableHeaderTheme macosYosemiteTheme_;
    private static TableHeaderTheme oldMacosTheme_;

    public TableHeaderTheme(Object ... props) {
        if (props.length % 2 != 0) {
            throw new IllegalArgumentException("Bad number of properties and keys.");
        }
        for (int i = 0; i < props.length; i += 2) {
            if (props[i] == null) {
                throw new IllegalArgumentException("Property " + i / 2 + " key is null.");
            }
            if (!(props[i] instanceof ThemeKey)) {
                throw new IllegalArgumentException("Property " + i / 2 + " key is not a ThemeKey.");
            }
            this.themeProps_.put((ThemeKey)((Object)props[i]), props[i + 1]);
        }
    }

    public boolean getBoolean(ThemeKey key) {
        Object o = this.themeProps_.get((Object)key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public Color getColor(ThemeKey key) {
        Object o = this.themeProps_.get((Object)key);
        if (o instanceof Color) {
            return this.cloneColor((Color)o);
        }
        return null;
    }

    public int getInt(ThemeKey key) {
        Object o = this.themeProps_.get((Object)key);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    private Color cloneColor(Color color) {
        Color cnew = new Color(color.getRGB());
        return cnew;
    }

    public static TableHeaderTheme getMacosYosemiteTheme() {
        if (macosYosemiteTheme_ == null) {
            macosYosemiteTheme_ = new TableHeaderTheme(new Object[]{ThemeKey.UNSELECTED_TOP_COLOR, GRAY_240, ThemeKey.UNSELECTED_BOTTOM_COLOR, GRAY_240, ThemeKey.LEFT_UNSELECTED_BORDER_COLOR, GRAY_240, ThemeKey.RIGHT_UNSELECTED_BORDER_COLOR, GRAY_216, ThemeKey.SELECTED_TOP_COLOR, GRAY_228, ThemeKey.SELECTED_BOTTOM_COLOR, GRAY_228, ThemeKey.LEFT_SELECTED_BORDER_COLOR, GRAY_228, ThemeKey.RIGHT_SELECTED_BORDER_COLOR, GRAY_216, ThemeKey.PRESSED_UNSELECTED_TOP_COLOR, GRAY_228, ThemeKey.PRESSED_UNSELECTED_BOTTOM_COLOR, GRAY_228, ThemeKey.LEFT_PRESSED_UNSELECTED_BORDER_COLOR, GRAY_228, ThemeKey.PRESSED_SELECTED_TOP_COLOR, GRAY_228, ThemeKey.PRESSED_SELECTED_BOTTOM_COLOR, GRAY_228, ThemeKey.BOTTOM_BORDER_COLOR, GRAY_192, ThemeKey.TOP_BOTTOM_PADDING, 4, ThemeKey.FONT_STYLE, 0, ThemeKey.FONT_EMPHASIZED, false});
        }
        return macosYosemiteTheme_;
    }

    public static TableHeaderTheme getOldMacosTheme() {
        if (oldMacosTheme_ == null) {
            oldMacosTheme_ = new TableHeaderTheme(new Object[]{ThemeKey.UNSELECTED_TOP_COLOR, new Color(219, 219, 219), ThemeKey.UNSELECTED_BOTTOM_COLOR, new Color(187, 187, 187), ThemeKey.LEFT_UNSELECTED_BORDER_COLOR, new Color(217, 217, 217), ThemeKey.RIGHT_UNSELECTED_BORDER_COLOR, new Color(156, 156, 156), ThemeKey.SELECTED_TOP_COLOR, new Color(194, 207, 221), ThemeKey.SELECTED_BOTTOM_COLOR, new Color(125, 147, 178), ThemeKey.LEFT_SELECTED_BORDER_COLOR, new Color(171, 187, 206), ThemeKey.RIGHT_SELECTED_BORDER_COLOR, new Color(138, 151, 166), ThemeKey.PRESSED_UNSELECTED_TOP_COLOR, new Color(196, 196, 196), ThemeKey.PRESSED_UNSELECTED_BOTTOM_COLOR, new Color(149, 149, 149), ThemeKey.LEFT_PRESSED_UNSELECTED_BORDER_COLOR, new Color(192, 192, 192), ThemeKey.PRESSED_SELECTED_TOP_COLOR, new Color(150, 183, 203), ThemeKey.PRESSED_SELECTED_BOTTOM_COLOR, new Color(83, 107, 144), ThemeKey.BOTTOM_BORDER_COLOR, new Color(85, 85, 85), ThemeKey.TOP_BOTTOM_PADDING, 0, ThemeKey.FONT_STYLE, 1, ThemeKey.FONT_EMPHASIZED, true});
        }
        return oldMacosTheme_;
    }

    public static enum ThemeKey {
        LEFT_UNSELECTED_BORDER_COLOR,
        LEFT_PRESSED_UNSELECTED_BORDER_COLOR,
        LEFT_SELECTED_BORDER_COLOR,
        RIGHT_UNSELECTED_BORDER_COLOR,
        RIGHT_SELECTED_BORDER_COLOR,
        BOTTOM_BORDER_COLOR,
        UNSELECTED_TOP_COLOR,
        UNSELECTED_BOTTOM_COLOR,
        SELECTED_TOP_COLOR,
        SELECTED_BOTTOM_COLOR,
        PRESSED_UNSELECTED_TOP_COLOR,
        PRESSED_UNSELECTED_BOTTOM_COLOR,
        PRESSED_SELECTED_TOP_COLOR,
        PRESSED_SELECTED_BOTTOM_COLOR,
        TOP_BOTTOM_PADDING,
        FONT_STYLE,
        FONT_EMPHASIZED;

    }
}

