/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class PrintfFormat {
    public static final PrintfFormat PFORMAT_2 = new PrintfFormat("%.2f");
    public static final PrintfFormat PFORMAT_3 = new PrintfFormat("%.3f");
    public static final PrintfFormat PFORMAT_2E = new PrintfFormat("%.2E");
    public static final PrintfFormat PFORMAT_3G = new PrintfFormat("%.3g");
    public static final PrintfFormat PFORMAT_4G = new PrintfFormat("%.4g");
    public static final PrintfFormat PFORMAT_5G = new PrintfFormat("%.5g");
    public static final PrintfFormat PFORMAT_6G = new PrintfFormat("%.6g");
    public static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    public static final PrintfFormat PFORMAT_9G = new PrintfFormat("%.9g");
    public static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");
    private Locale locale_;
    private String format_;
    private boolean isSimpleG_;
    private char decimalChar_;
    private String lcExponentStr_;

    public PrintfFormat(String format) {
        this.format_ = format;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.decimalChar_ = dfs.getDecimalSeparator();
        String exponentStr = dfs.getExponentSeparator();
        this.lcExponentStr_ = exponentStr.toLowerCase();
        this.isSimpleG_ = this.format_.matches("%\\d*\\.\\d+g") || this.format_.matches("%\\d*\\.\\d+G");
    }

    public PrintfFormat(Locale l, String format) {
        this.locale_ = l;
        this.format_ = format;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.decimalChar_ = dfs.getDecimalSeparator();
        String exponentStr = dfs.getExponentSeparator();
        this.lcExponentStr_ = exponentStr.toLowerCase();
        this.isSimpleG_ = this.format_.matches("%\\d*\\.\\d+g") || this.format_.matches("%\\d*\\.\\d+G");
    }

    public String sprintf(Object arg) {
        if (this.locale_ != null) {
            return String.format(this.locale_, this.format_, arg);
        }
        return String.format(this.format_, arg);
    }

    public String sprintf(Object ... args) {
        if (this.locale_ != null) {
            return String.format(this.locale_, this.format_, args);
        }
        return String.format(this.format_, args);
    }

    public String sprintg(Object arg) {
        String sval = this.sprintf(arg);
        if (!this.isSimpleG_) {
            return sval;
        }
        int decimalIndex = sval.indexOf(this.decimalChar_);
        int expIndex = sval.toLowerCase().indexOf(this.lcExponentStr_);
        if (decimalIndex < 0) {
            return sval;
        }
        String expString = null;
        if (expIndex > 0) {
            expString = sval.substring(expIndex);
            sval = sval.substring(0, expIndex);
        }
        if (sval.endsWith("0")) {
            while (sval.endsWith("00")) {
                sval = sval.substring(0, sval.length() - 1);
            }
            if (!sval.endsWith(this.decimalChar_ + "0") && sval.endsWith("0")) {
                sval = sval.substring(0, sval.length() - 1);
            }
        }
        if (expString != null) {
            sval = sval + expString;
        }
        return sval;
    }

    public char getDecimalChar() {
        return this.decimalChar_;
    }
}

