/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.Panoply;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanLoggingUtils {
    private static boolean initted_;

    public static void initLogging(boolean toConsole) {
        if (toConsole) {
            PanLoggingUtils.initLogging(LogLocation.CONSOLE);
        } else {
            PanLoggingUtils.initLogging(LogLocation.USERLIB);
        }
    }

    private static void initLogging(LogLocation logLocation) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        if (initted_) {
            logger.warn("Logging previously initialized.");
        }
        if (logLocation == LogLocation.USERLIB) {
            PanLoggingUtils.redirectStdoutStderrToCustomLog();
        }
        try {
            InputStream is = Panoply.class.getResourceAsStream("resources/logging.properties");
            if (is == null) {
                throw new RuntimeException("Failed to load logging.properties");
            }
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (Exception exc) {
            logger.warn("Error reading logging properties.");
            exc.printStackTrace();
        }
        initted_ = true;
    }

    public static void redirectStdoutStderrToCustomLog() {
        File logsDir = FileUtils.getGISSLogsDirectory();
        if (!logsDir.exists()) {
            logsDir.mkdirs();
        }
        File ff = new File(logsDir, "panoply.log");
        try {
            PrintStream ps = new PrintStream(ff);
            System.setOut(ps);
            System.setErr(ps);
        }
        catch (Exception exc) {
            Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
            logger.warn("Could not redirect STDOUT/STDERR to logs dir file: {}", (Object)ff);
            logger.warn("Exception reported was: {}", exc);
        }
    }

    public static void setLogLevel(String level) {
        String[] pkgnames;
        Objects.requireNonNull(level, "Log level cannot be null");
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.trace("level '{}'", (Object)level);
        if (level.isEmpty()) {
            logger.info("Passed logging level is empty; no change will be made,");
            return;
        }
        logger.info("Attempting to change log level to {}", (Object)level);
        for (String pkgname : pkgnames = new String[]{"gov.nasa.giss", "gov.nasa.giss.panoply", "gov.nasa.giss.data.nc"}) {
            java.util.logging.Logger pkglogger = java.util.logging.Logger.getLogger(pkgname);
            try {
                Level newLevel = Level.parse(level.toUpperCase());
                pkglogger.setLevel(newLevel);
                logger.info("Changed {} log level to {}", (Object)pkgname, (Object)newLevel);
            }
            catch (Exception exc) {
                logger.warn("Setting {} log level {} failed.", (Object)pkgname, (Object)level);
            }
        }
    }

    private PanLoggingUtils() {
    }

    public static enum LogLocation {
        CONSOLE,
        USERLIB;

    }
}

