/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanContourLocation implements DescribedItem
{
    MAJOR("Major scale ticks only"),
    MINOR("Major and minor scale ticks");

    private final String description_;

    private PanContourLocation(String description) {
        this.description_ = description;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanContourLocation matching(String s) {
        for (PanContourLocation item : PanContourLocation.values()) {
            if (!item.name().equalsIgnoreCase(s) && !item.toString().equalsIgnoreCase(s) && !item.getDescription().equalsIgnoreCase(s)) continue;
            return item;
        }
        return null;
    }
}

