/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.panoply.util.PanProperties;

public final class PanConstants {
    public static final String SOFTWARE;
    public static final int MAX_SIZE_FACTOR = 300;
    public static final int MAX_SIZE_FACTOR_CL = 500;
    public static final int MIN_SIZE_FACTOR = 80;
    public static final int MAX_HEIGHT_FACTOR = 400;
    public static final int MIN_HEIGHT_FACTOR = 20;
    public static final int MAX_WIDTH_FACTOR = 100;
    public static final int MIN_WIDTH_FACTOR = 20;
    public static final double LOG_MIN_VAL = 1.0E-50;
    public static final double TINY_VAL = 1.0E-25;
    public static final int SCALE_DIVS_MAX = 20;
    public static final String[] ANGLE_UNITS;
    public static final String[] DISTANCE_UNITS;
    public static final String[] PRESSURE_UNITS;
    public static final String[] SPEED_UNITS;
    public static final String[] TEMPERATURE_UNITS;
    public static final String[] TIME_DISPLAY_PATTERNS;

    private PanConstants() {
    }

    static {
        StringBuilder sb = new StringBuilder().append(PanProperties.VERSION_PROPS.getString("application-name")).append(' ').append(PanProperties.VERSION_PROPS.getString("version"));
        SOFTWARE = sb.toString();
        ANGLE_UNITS = new String[]{"degree", "radian", "arcdeg", "arcmin", "arcsec"};
        DISTANCE_UNITS = new String[]{"m", "km", "foot", "mile"};
        PRESSURE_UNITS = new String[]{"Pa", "hPa", "kPa", "millibar", "bar", "atmosphere"};
        SPEED_UNITS = new String[]{"m/s", "km/hour", "mile/hour", "knot"};
        TEMPERATURE_UNITS = new String[]{"Kelvin", "K", "Celsius", "deg_C", "Fahrenheit", "deg_F"};
        TIME_DISPLAY_PATTERNS = new String[]{"yyyy", "yyyy-MM", "yyyy-MM-dd", "yyyy-MM-dd HH", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "MM-dd", "MM-dd HH", "MM-dd HH:mm", "MM-dd HH:mm:ss", "HH:mm", "HH:mm:ss"};
    }
}

