/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanAlphaMethod implements DescribedItem
{
    CONSTANT("Constant", 1),
    SATURATION("Based on Color Saturation", 2),
    BRIGHTNESS("Based on Color Brightness", 2),
    DARKNESS("Based on Color Darkness", 2),
    MINMAX("Min to Max", 2),
    MAXMIN("Max to Min", 2),
    DIVERGE("Divergent", 2);

    private final String description_;
    private final int alphaCount_;

    private PanAlphaMethod(String description, int alphaCount) {
        this.description_ = description;
        this.alphaCount_ = alphaCount;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public int getAlphaCount() {
        return this.alphaCount_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanAlphaMethod matching(String s) {
        for (PanAlphaMethod item : PanAlphaMethod.values()) {
            if (!item.matches(s)) continue;
            return item;
        }
        return null;
    }
}

