/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.lang.invoke.MethodHandles;
import javax.swing.JComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanOverlayComboBox
extends JComboBox<Object>
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static OverlayResourceList overlayList_ = PanUtils.getOverlayResourceList();
    private boolean firstIsNone_ = true;

    public PanOverlayComboBox(boolean includeNone) {
        this(PanGuiSize.REGULAR, includeNone);
    }

    public PanOverlayComboBox(PanGuiSize size, boolean includeNone) {
        super(overlayList_.toArray());
        this.firstIsNone_ = includeNone;
        if (this.firstIsNone_) {
            this.insertItemAt("None", 0);
            this.setSelectedIndex(0);
        }
        overlayList_.addListDataListener(this);
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else {
            super.setSelectedItem(item);
        }
    }

    public void setSelectedItem(MapOverlay item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else {
            super.setSelectedItem(item);
        }
    }

    public void setSelectedItemByName(String item) {
        if (item == null) {
            this.setSelectedIndex(0);
            return;
        }
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            if (!this.getItemAt(i).toString().equals(item)) continue;
            super.setSelectedIndex(i);
            return;
        }
    }

    public MapOverlay getOverlay() {
        Object o = this.getSelectedItem();
        if (o instanceof MapOverlay) {
            return (MapOverlay)o;
        }
        return null;
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        LOGGER.debug("Not implemented.");
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        int offset = this.firstIsNone_ ? 1 : 0;
        OverlayResourceList oList = PanUtils.getOverlayResourceList();
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        for (int i = index0; i <= index1; ++i) {
            Object olay = oList.getBackingObject(i);
            this.insertItemAt(olay, i + offset);
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index1;
        int offset = this.firstIsNone_ ? 1 : 0;
        int index = this.getSelectedIndex();
        int index0 = e.getIndex0();
        for (int i = index1 = e.getIndex1(); i >= index0; --i) {
            this.removeItemAt(i + offset);
        }
        if (index >= index0 + offset && index <= index1 + offset) {
            if (index0 > 0) {
                this.setSelectedIndex(index0 - 1 + offset);
            } else {
                this.setSelectedIndex(index0 + offset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanOverlayComboBox panOverlayComboBox = this;
        synchronized (panOverlayComboBox) {
            overlayList_.removeListDataListener(this);
            this.removeAll();
        }
    }
}

