/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import javax.swing.JComboBox;

public final class PanAxisMethodComboBox
extends JComboBox<PanAxisMethod> {
    private PanAxisMethodComboBox(PanGuiSize size, String name, boolean includeIndexMethod) {
        this.addItem(PanAxisMethod.SCALAR);
        this.addItem(PanAxisMethod.LOG10);
        if (includeIndexMethod) {
            this.addItem(PanAxisMethod.INDEX);
        }
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public static PanAxisMethodComboBox createSmall(String name, boolean includeIndexMethod) {
        return new PanAxisMethodComboBox(PanGuiSize.SMALL, name, includeIndexMethod);
    }

    public PanAxisMethod getSelectedMethod() {
        int idx = this.getSelectedIndex();
        return (PanAxisMethod)this.getItemAt(idx);
    }

    public String getStringValue() {
        int idx = this.getSelectedIndex();
        PanAxisMethod item = (PanAxisMethod)this.getItemAt(idx);
        return item.name();
    }

    public void setSelectedItem(String s) {
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            PanAxisMethod pam = (PanAxisMethod)this.getItemAt(i);
            if (!pam.matches(s)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }
}

