/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanPanel;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.event.TreeTableEvent;
import gov.nasa.giss.ui.event.TreeTableListener;
import gov.nasa.giss.ui.plaf.BlackSplitPaneUI;
import gov.nasa.giss.ui.treetable.SearchableTreeTablePanel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class PanSourcesPanel
extends JPanel
implements PropertyChangeListener,
TreeTableListener {
    protected final PanSourcesFrame parent_;
    private final JComponent leftPanel_;
    private JComponent treeHolder_;
    protected SearchableTreeTablePanel ttPanel_;
    private JComponent findPanel_;
    protected PanTextField findTermTF_;
    private PanButton findNextButton_;
    protected static String commonFindTerm_ = "";
    private JComponent rightPanel_;
    protected JEditorPane infoPane_;
    private final JSplitPane splitPane_;
    private static boolean ignorePCEvents_;

    public PanSourcesPanel(PanSourcesFrame parent, boolean includeInfo) {
        this.parent_ = parent;
        this.setLayout(new BorderLayout());
        this.setBorder(PanGuiConstants.NO_BORDER);
        this.setOpaque(false);
        this.splitPane_ = new JSplitPane(1, true);
        this.splitPane_.setUI(new BlackSplitPaneUI());
        this.splitPane_.setDividerSize(2);
        this.splitPane_.setBorder(PanGuiConstants.NO_BORDER);
        this.splitPane_.setResizeWeight(0.5);
        this.splitPane_.setOpaque(false);
        this.splitPane_.addPropertyChangeListener(this);
        this.setMinimumSize(new Dimension(540, 300));
        this.setPreferredSize(this.getMinimumSize());
        this.leftPanel_ = this.makeLeftPanel();
        this.leftPanel_.setMinimumSize(new Dimension(135, 300));
        if (includeInfo) {
            this.rightPanel_ = this.makeRightPanel();
            this.rightPanel_.setMinimumSize(new Dimension(135, 300));
        }
    }

    private JComponent makeLeftPanel() {
        PanPanel panel = new PanPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(false);
        panel.setBorder(null);
        this.treeHolder_ = this.makeTreeHolder();
        panel.add(this.treeHolder_);
        this.findPanel_ = this.makeFindPanel();
        return panel;
    }

    protected abstract JComponent makeTreeHolder();

    private JComponent makeFindPanel() {
        PanLabel findLabel = PanLabel.create("Find: ");
        this.findTermTF_ = PanTextField.createSearchField(null);
        this.findNextButton_ = PanButton.createSegmented("first", null, "Find");
        PanButton findDoneButton = PanButton.createSegmented("last", null, "Done");
        PanButton altNextButton = PanButton.createSegmented("first", null, "Next");
        Dimension d1 = this.findNextButton_.getMinimumSize();
        Dimension d2 = altNextButton.getMinimumSize();
        if (d1.width < d2.width) {
            this.findNextButton_.setMinimumSize(d2);
            this.findNextButton_.setMaximumSize(d2);
        }
        this.findNextButton_.setRequestFocusEnabled(false);
        findDoneButton.setRequestFocusEnabled(false);
        QuickBox panel = QuickBox.createHorizontalBox(findLabel, this.findTermTF_, this.findNextButton_, findDoneButton);
        panel.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        panel.setOpaque(false);
        d2 = panel.getPreferredSize();
        panel.setMinimumSize(new Dimension(20, d2.height));
        panel.setMaximumSize(new Dimension(2000, d2.height));
        this.findTermTF_.addActionListener(e -> this.findNext());
        this.findTermTF_.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateCommon();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateCommon();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateCommon();
            }

            private final void updateCommon() {
                commonFindTerm_ = PanSourcesPanel.this.findTermTF_.getText();
                PanSourcesPanel.this.findNextButton_.setText("Find");
            }
        });
        this.findNextButton_.addActionListener(e -> {
            commonFindTerm_ = this.findTermTF_.getText();
            this.findNext();
        });
        findDoneButton.addActionListener(e -> {
            this.showSearch(false);
            this.findNextButton_.setText("Find");
        });
        return panel;
    }

    private JComponent makeRightPanel() {
        this.infoPane_ = new JEditorPane("text/plain", "");
        this.infoPane_.setFont(new Font("Monospaced", 0, 12));
        this.infoPane_.setEditable(false);
        this.infoPane_.setBorder(PanGuiConstants.NO_BORDER);
        JScrollPane infoSPane = new JScrollPane(this.infoPane_);
        infoSPane.setHorizontalScrollBarPolicy(30);
        infoSPane.setVerticalScrollBarPolicy(22);
        infoSPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        return infoSPane;
    }

    protected abstract void refreshInfoBox();

    public void showSearch(boolean visible) {
        if (visible) {
            if (!this.leftPanel_.isAncestorOf(this.findPanel_)) {
                this.leftPanel_.removeAll();
                this.leftPanel_.add(this.findPanel_);
                this.leftPanel_.add(this.treeHolder_);
                this.findNextButton_.setText("Find");
            }
            this.leftPanel_.validate();
            this.findTermTF_.grabFocus();
        } else if (this.leftPanel_.isAncestorOf(this.findPanel_)) {
            this.leftPanel_.remove(this.findPanel_);
            this.leftPanel_.validate();
        }
    }

    protected String getSearchTerm() {
        return commonFindTerm_;
    }

    public void findNext() {
        String sterm = this.getSearchTerm();
        if (sterm == null || sterm.length() < 1) {
            return;
        }
        boolean found = this.ttPanel_.searchForNext(sterm);
        if (found) {
            this.findNextButton_.setText("Next");
            this.refreshInfoBox();
        } else {
            this.findNextButton_.setText("Find");
        }
    }

    public abstract void refreshActions();

    public abstract void removeNode(TreeTableNode var1);

    public abstract void clear();

    public TreeTableNode getSelectedNode() {
        return this.ttPanel_.getTreeTable().getSelectedNode();
    }

    public void remakeLayout() {
        this.findTermTF_.setText(commonFindTerm_);
        if (this.rightPanel_ == null) {
            this.removeAll();
            this.add((Component)this.leftPanel_, "Center");
            this.validate();
            return;
        }
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (prefs.getBoolean("sources:info.vis")) {
            if (this.isAncestorOf(this.leftPanel_) && this.leftPanel_.getParent() == this) {
                this.remove(this.leftPanel_);
            }
            if (!this.isAncestorOf(this.splitPane_)) {
                this.splitPane_.setLeftComponent(this.leftPanel_);
                this.splitPane_.setRightComponent(this.rightPanel_);
                this.add((Component)this.splitPane_, "Center");
            }
            int panelWidth = prefs.getInt("sources:bounds.width");
            int newInfoPct = prefs.getInt("sources:info.width");
            int infoWidth = newInfoPct > 10 && newInfoPct < 90 ? newInfoPct * panelWidth / 100 : panelWidth * 3 / 10;
            this.splitPane_.setDividerLocation(panelWidth - infoWidth);
        } else {
            if (this.isAncestorOf(this.splitPane_)) {
                ignorePCEvents_ = true;
                this.remove(this.splitPane_);
                ignorePCEvents_ = false;
            }
            if (this.leftPanel_.getParent() == this.splitPane_) {
                this.splitPane_.remove(this.leftPanel_);
            }
            this.add((Component)this.leftPanel_, "Center");
        }
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (ignorePCEvents_) {
            return;
        }
        String pname = e.getPropertyName();
        if (!pname.equals("dividerLocation")) {
            return;
        }
        if (this.isAncestorOf(this.splitPane_) && pname.equals("dividerLocation")) {
            int newLocation = this.splitPane_.getDividerLocation();
            int panelWidth = this.splitPane_.getWidth();
            if (newLocation > 0 && newLocation < panelWidth) {
                int newInfoPct = this.rightPanel_.getWidth() * 100 / panelWidth;
                PanPreferences prefs = PanPreferences.getSharedInstance();
                prefs.setInt("sources:info.width", newInfoPct);
            }
        }
    }

    @Override
    public void removalRequested(TreeTableEvent e) {
        TreeTableNode node = this.ttPanel_.getTreeTable().getSelectedNode();
        this.removeNode(node);
    }

    @Override
    public void itemRemoved(TreeTableEvent e) {
        this.refreshActions();
        this.repaint();
    }
}

