/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.server;

import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String PROTOCOL_VERSION = "4.5";
    private static final int WAITING = 0;
    private static final int PROTOCOL = 1;
    private static final int VERSION_PROPS = 2;
    private static final int ASKFILE = 3;
    private static final int ERROR = 4;
    private static final int CONTINUE = 5;
    private int state_ = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String processInput(String input) {
        LOGGER.trace("state '{}' -- process '{}'", (Object)this.state_, (Object)input);
        if (input != null && input.equalsIgnoreCase("bye.")) {
            this.state_ = 0;
            return "Bye.";
        }
        String output = null;
        switch (this.state_) {
            case 0: {
                output = "panoply";
                this.state_ = 1;
                return output;
            }
            case 1: {
                output = "version";
                this.state_ = 2;
                return output;
            }
            case 2: {
                if (input.equalsIgnoreCase(PROTOCOL_VERSION)) {
                    output = "filepath";
                    this.state_ = 3;
                    return output;
                }
                output = "Error. Panoply version mis-match.";
                this.state_ = 0;
                return output;
            }
            case 3: {
                LOGGER.trace("handling ASKFILE {}", (Object)input);
                LOGGER.trace("finding sources frame");
                PanSourcesFrame sourcesFrame = PanSourcesFrame.getSharedInstance();
                LOGGER.trace("found frame");
                if (!NcFilenameFilter.accept(input)) return "Error opening " + input + ". No '.nc' filename extension.";
                LOGGER.trace("adding dataset");
                try {
                    LOGGER.trace("making File object");
                    File f = new File(input);
                    LOGGER.trace("adding dataset");
                    PanFileUtils.openDataset(f);
                }
                catch (Exception exc) {
                    return "Error opening " + input + ". " + exc.toString();
                }
                sourcesFrame.repaint();
                sourcesFrame.setVisible(true);
                sourcesFrame.toFront();
                output = "continue?";
                this.state_ = 5;
                return output;
            }
            case 4: {
                output = "continue?";
                this.state_ = 5;
                return output;
            }
            case 5: {
                if (input.equalsIgnoreCase("y")) {
                    output = "filepath";
                    this.state_ = 3;
                    return output;
                }
                output = "Bye.";
                this.state_ = 0;
                return output;
            }
            default: {
                LOGGER.trace("Switch - How did we get here? {}", (Object)this.state_);
                System.exit(1);
            }
        }
        return output;
    }
}

