/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanClient(ArrayList<File> files) throws IOException, UnknownHostException {
        Socket socket = new Socket((String)null, 2880);
        PrintWriter toServer = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader fromServer = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        int isize = files.size();
        int sentCount = 0;
        if (isize > 0) {
            String input;
            while ((input = fromServer.readLine()) != null) {
                String output;
                LOGGER.trace("rec from server: '{}'", (Object)input);
                if (input.equals("Bye.")) break;
                if (input.equalsIgnoreCase("panoply")) {
                    output = "panoply";
                } else if (input.equalsIgnoreCase("version")) {
                    output = "4.5";
                } else if (input.equalsIgnoreCase("filepath")) {
                    output = files.get(sentCount).getAbsolutePath();
                    ++sentCount;
                } else if (input.toLowerCase().startsWith("error")) {
                    output = "acknowledged";
                } else {
                    if (!input.equalsIgnoreCase("continue?")) break;
                    output = sentCount < isize ? "y" : "n";
                }
                LOGGER.trace("send to server: '{}'", (Object)output);
                toServer.println(output);
            }
        }
        toServer.println("Bye.");
        toServer.close();
        fromServer.close();
        socket.close();
    }
}

