/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanVectorStyle;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanVectorPrefsPanel
extends PanAbstractPrefsPanel {
    private PanEnumComboBox styleCombo_;
    private PanColorComboBox colorCombo_;
    private PanIntSpinner weightSpinner_;
    private PanIntSpinner spacingSpinner_;
    private PanCheckBox sampleVisCB_;

    public PanVectorPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.styleCombo_ = PanEnumComboBox.create(PanVectorStyle.class);
        this.colorCombo_ = PanColorComboBox.createRainbow(null);
        this.weightSpinner_ = PanIntSpinner.createPct(0);
        this.spacingSpinner_ = PanIntSpinner.create(100, 25, 250, 1);
        this.sampleVisCB_ = PanCheckBox.create("Visible", true);
        PanLabel bText = PanLabel.createSmall("Vectors are only available in lon-lat, lat-vert and lon-vert plots.");
        FlexingGridLayout fgl = new FlexingGridLayout(3, 6, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Vector Defaults"));
        this.add((Component)bText, new FGConstraint(0, 0, 3, 1, 0.5, 0.5));
        this.add((Component)new JLabel("Style: "), new FGConstraint(0, 2, 1.0));
        this.add((Component)this.styleCombo_, new FGConstraint(1, 2));
        this.add((Component)new JLabel("Spacing: "), new FGConstraint(0, 3, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.spacingSpinner_, new JLabel("%")), new FGConstraint(1, 3));
        this.add((Component)new JLabel("Color: "), new FGConstraint(0, 4, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.colorCombo_, new JLabel(", Weight: "), this.weightSpinner_), new FGConstraint(1, 4));
        this.add((Component)new JLabel("Sample: "), new FGConstraint(0, 5, 1.0));
        this.add((Component)this.sampleVisCB_, new FGConstraint(1, 5));
    }

    private final void attachListeners() {
        this.styleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:vector.style", this.styleCombo_.getStringValue());
        });
        this.colorCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:vector.color", this.colorCombo_.getSelectedColor());
        });
        this.weightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:vector.weight", this.weightSpinner_.getIntValue());
        });
        this.spacingSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:vector.spacing", this.spacingSpinner_.getIntValue());
        });
        this.sampleVisCB_.addItemListener(e -> prefs_.setBoolean("plot:vector.sample", this.sampleVisCB_.isSelected()));
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.styleCombo_.setSelectedItem(prefs_.getString("plot:vector.style"));
        this.colorCombo_.setSelectedColor(prefs_.getColor("plot:vector.color"));
        this.weightSpinner_.setValue(prefs_.getInt("plot:vector.weight"));
        this.spacingSpinner_.setValue(prefs_.getInt("plot:vector.spacing"));
        this.sampleVisCB_.setSelected(prefs_.getBoolean("plot:vector.sample"));
        this.refreshing_ = false;
    }
}

