/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.BoxLayout;

public class PanOutputPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox imageDialogAlwaysCB_;
    private PanCheckBox pspdfVectorizedCB_;
    private PanCheckBox exportWarningCB_;
    private PanEnumComboBox pspdfPaperSizeCombo_;

    public PanOutputPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.imageDialogAlwaysCB_ = PanCheckBox.create("Always show file dialog when saving plot graphics");
        this.pspdfVectorizedCB_ = PanCheckBox.create("Save PS and PDF plot graphics fully vectorized");
        this.pspdfPaperSizeCombo_ = PanEnumComboBox.create(PaperSize.class);
        this.exportWarningCB_ = PanCheckBox.create("Show large-file warning when exporting data");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Save"));
        this.add(QuickBox.createLeftBox(this.imageDialogAlwaysCB_));
        this.add(QuickBox.createLeftBox(this.pspdfVectorizedCB_));
        this.add(QuickBox.createLeftBox(PanLabel.create("       Output paper size for PS/PDF graphics: "), this.pspdfPaperSizeCombo_));
        this.add(QuickBox.createLeftBox(this.exportWarningCB_));
    }

    private final void attachListeners() {
        this.imageDialogAlwaysCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("files:save.image.dialog", this.imageDialogAlwaysCB_.isSelected());
        });
        this.pspdfVectorizedCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("files:save.pspdf.vectorized", this.pspdfVectorizedCB_.isSelected());
        });
        this.pspdfPaperSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PaperSize selected = (PaperSize)this.pspdfPaperSizeCombo_.getSelectedItem();
            prefs_.set("files:save.pspdf.paper", selected.name());
        });
        this.exportWarningCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("files:save.export.warning", this.exportWarningCB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        PaperSize pps = PaperSize.matching(PanPreferences.getSharedInstance().getString("files:save.pspdf.paper"));
        this.imageDialogAlwaysCB_.setSelected(prefs_.getBoolean("files:save.image.dialog"));
        this.pspdfVectorizedCB_.setSelected(prefs_.getBoolean("files:save.pspdf.vectorized"));
        this.pspdfPaperSizeCombo_.setSelectedItem(pps);
        this.exportWarningCB_.setSelected(prefs_.getBoolean("files:save.export.warning"));
        this.refreshing_ = false;
    }
}

