/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.Point;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLinePlotStrokePrefsPanel
extends PanAbstractPrefsPanel {
    private PanColorComboBox[] strokeColorCombos_ = new PanColorComboBox[2];
    private PanEnumComboBox[] strokeStyleMenus_ = new PanEnumComboBox[2];
    private PanIntSpinner[] strokeWeightSpinners_ = new PanIntSpinner[2];

    public PanLinePlotStrokePrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Line Plot Stroke Defaults"));
        PanLabel topText = PanLabel.create("When creating a line plot, set\u2026");
        PanLabel t1Label = PanLabel.create("Stroke 1: ");
        PanLabel t2Label = PanLabel.create("Stroke 2: ");
        QuickBox[] strokeStyleBoxes = new QuickBox[2];
        QuickBox[] strokeColorBoxes = new QuickBox[2];
        QuickBox[] symbolBoxes = new QuickBox[2];
        for (int i = 0; i < 2; ++i) {
            PanLabel t1StrokeLabel1 = PanLabel.create("Style: ");
            PanLabel t2StrokeLabel1 = PanLabel.create("Color: ");
            PanLabel t2StrokeLabel2 = PanLabel.create(", Weight: ");
            PanLabel t2StrokeLabel3 = PanLabel.create("%");
            this.strokeStyleMenus_[i] = PanEnumComboBox.create(PanParameterKeys.P_LINE_STROKE_STYLE[i], PanStrokeStyle.class);
            this.strokeStyleMenus_[i].removeItem(PanStrokeStyle.NONE);
            this.strokeStyleMenus_[i].setSelectedItem(prefs_.getString(PanParameterKeys.P_LINE_STROKE_STYLE[i]));
            this.strokeColorCombos_[i] = PanColorComboBox.createRainbow(PanParameterKeys.P_LINE_STROKE_COLOR[i]);
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParameterKeys.P_LINE_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i] = PanIntSpinner.createWeightX5(PanParameterKeys.P_LINE_STROKE_WEIGHT[i], prefs_.getInt(PanParameterKeys.P_LINE_STROKE_WEIGHT[i]), 500);
            strokeStyleBoxes[i] = QuickBox.createLeftBox(t1StrokeLabel1, this.strokeStyleMenus_[i]);
            strokeColorBoxes[i] = QuickBox.createLeftBox(t2StrokeLabel1, this.strokeColorCombos_[i], t2StrokeLabel2, this.strokeWeightSpinners_[i], t2StrokeLabel3, Box.createHorizontalStrut(12));
            GuiUtils.matchLabelWidths(t1StrokeLabel1, t2StrokeLabel1);
        }
        GuiUtils.matchLabelWidths(t1Label, t2Label);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 9, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setRowWeight(8, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 4, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, 1));
        this.add((Component)t1Label, new FGConstraint(0, 2));
        this.add((Component)strokeStyleBoxes[0], new FGConstraint(1, 2));
        this.add((Component)strokeColorBoxes[0], new FGConstraint(1, 3));
        this.add((Component)t2Label, new FGConstraint(0, 4));
        this.add((Component)strokeStyleBoxes[1], new FGConstraint(1, 4));
        this.add((Component)strokeColorBoxes[1], new FGConstraint(1, 5));
        this.add(Box.createVerticalGlue(), new Point(0, 6));
    }

    private final void attachListeners() {
        int i = 0;
        while (i < 2) {
            int ii = i++;
            this.strokeColorCombos_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.refreshing_) {
                    return;
                }
                prefs_.set(PanParameterKeys.P_LINE_STROKE_COLOR[ii], this.strokeColorCombos_[ii].getSelectedColor());
            });
            this.strokeStyleMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParameterKeys.P_LINE_STROKE_STYLE[ii], this.strokeStyleMenus_[ii].getStringValue());
            });
            this.strokeWeightSpinners_[ii].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setInt(PanParameterKeys.P_LINE_STROKE_WEIGHT[ii], this.strokeWeightSpinners_[ii].getIntValue());
            });
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        for (int i = 0; i < 2; ++i) {
            this.strokeStyleMenus_[i].setSelectedItem(prefs_.getString(PanParameterKeys.P_LINE_STROKE_STYLE[i]));
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParameterKeys.P_LINE_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i].setValue(prefs_.getInt(PanParameterKeys.P_LINE_STROKE_WEIGHT[i]));
        }
        this.refreshing_ = false;
    }
}

