/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.bookmarks.PanHistoryList;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCommonComboBox;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class PanHistoryPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Integer[] DAYS = new Integer[]{Integer.valueOf("1"), Integer.valueOf("2"), Integer.valueOf("3"), Integer.valueOf("7"), Integer.valueOf("14"), Integer.valueOf("30"), Integer.valueOf("45"), Integer.valueOf("60"), Integer.valueOf("90"), Integer.valueOf("365")};
    private PanCommonComboBox daysCombo_;

    public PanHistoryPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.daysCombo_ = new PanCommonComboBox(PanGuiSize.REGULAR, null, DAYS);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("History"));
        this.add(QuickBox.createLeftBox(new JLabel("Remove history items after "), this.daysCombo_, new JLabel(" days")));
        this.daysCombo_.setMaximumSize(this.daysCombo_.getPreferredSize());
    }

    private final void attachListeners() {
        this.daysCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            Integer days = (Integer)this.daysCombo_.getSelectedItem();
            prefs_.setInt("files:history.days", days);
            PanHistoryList.getSharedInstance().enforceAgeLimit(days);
            GuiUtils.refreshFrontFrameMenuBar();
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.daysCombo_.setSelectedItem(prefs_.getInt("files:history.days"));
        this.refreshing_ = false;
    }
}

