/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableModel;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanColorbarTableModel
extends PanPrefsTableModel
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ColorTableResourceList reslist_ = PanUtils.getColorTableResourceList();

    public PanColorbarTableModel() {
        this.reslist_.addListDataListener(this);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this.reslist_ == null) {
            return 0;
        }
        return this.reslist_.getSize();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return AbstractColorTable.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Sample";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Status";
            }
        }
        return "Error";
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.reslist_.getBackingObject(row);
            }
            case 1: {
                return this.reslist_.getName(row);
            }
            case 2: {
                switch (this.reslist_.getLocType(row)) {
                    case INCODE: 
                    case JAR: {
                        return "Built-in";
                    }
                    case USERLIB: {
                        return "Library";
                    }
                }
                return "Session";
            }
        }
        return "Error";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        LOGGER.debug("Not implemented.");
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        this.fireTableRowsInserted(index0, index1);
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        this.fireTableRowsDeleted(index0, index1);
    }
}

