/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereGMAO;
import gov.nasa.giss.panoply.plotui.table.PanArray2DTableModel;
import gov.nasa.giss.text.PrintfFormat;

public class PanArrayCubedSphereGMAOTableModel
extends PanArray2DTableModel {
    private final NcArrayLonLatCubedSphereGMAO ncaCS_;
    private final int faceCols_;
    private final int faceRows_;

    public PanArrayCubedSphereGMAOTableModel(NcArrayLonLatCubedSphereGMAO array) {
        super(array);
        this.ncaCS_ = array;
        this.faceCols_ = this.array_.getXAxis().getLength();
        this.faceRows_ = this.array_.getYAxis().getLength();
    }

    @Override
    public int getColumnCount() {
        return this.faceCols_;
    }

    @Override
    public int getRowCount() {
        return 6 * this.faceRows_;
    }

    @Override
    public String getColumnName(int col) {
        try {
            int colx;
            int n = colx = this.flippedLR_ ? this.faceCols_ - 1 - col : col;
            if (this.showCellIndex_) {
                return Integer.toString(colx + 1);
            }
            double val = this.array_.getXAxis().valueAt(colx);
            return PrintfFormat.PFORMAT_7G.sprintg(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public String getRowName(int row) {
        int face = row / this.faceRows_;
        int faceRow = row % this.faceRows_;
        try {
            int rowx;
            int n = rowx = this.flippedBT_ ? this.faceRows_ - 1 - faceRow : faceRow;
            if (this.showCellIndex_) {
                return Integer.toString(rowx + 1);
            }
            double val = this.array_.getYAxis().valueAt(rowx);
            return "F" + (face + 1) + " - " + PrintfFormat.PFORMAT_7G.sprintg(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        int face = row / this.faceRows_;
        int faceRow = row % this.faceRows_;
        try {
            int rowx = this.flippedBT_ ? this.faceRows_ - 1 - faceRow : faceRow;
            int colx = this.flippedLR_ ? this.faceCols_ - 1 - col : col;
            this.ncaCS_.setCubeFace(face);
            return this.valFormatter_.sprintf((Object)this.array_.valueAt(colx, rowx));
        }
        catch (Exception ignore) {
            return "ERR";
        }
    }
}

