/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.panoply.action.PanFitScaleToClutAction;
import gov.nasa.giss.panoply.action.PanReverseColorbarAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanScaleControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanColorTableComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanScaleCaptionLocation;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanScaleControls2D
extends PanScaleControls
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanColorTableComboBox ctableCombo_;
    private PanCheckBox reversedCB_;
    private PanIntSpinner widthSpinner_;
    private PanColorComboBox iColorCombo_;
    private PanEnumComboBox outlierShapeCombo_;
    private PanEnumComboBox outlierSideCombo_;
    private PanEnumComboBox outlierGapCombo_;
    private PanEnumComboBox scaleCapPlaceCombo_;

    public PanScaleControls2D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    @Override
    protected final void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        PanReverseColorbarAction reverseColorbarAction = new PanReverseColorbarAction(this);
        PanFitScaleToClutAction fitScaleToClutAction = new PanFitScaleToClutAction(this.pmeta_, this);
        plotMenu.getItemByName("reverse-scale").setAction(reverseColorbarAction);
        plotMenu.getItemByName("fit-scale-to-clut").setAction(fitScaleToClutAction);
        plotMenu.getItemByName("reverse-scale").setSelected(this.pmeta_.getBoolean("scale.reverse"));
        this.pmeta_.putAction("reverse-scale", reverseColorbarAction);
        this.pmeta_.putAction("fit-scale-to-clut", fitScaleToClutAction);
        plotMenu.getItemByName("reverse-scale").setEnabled(true);
        plotMenu.getItemByName("fit-scale-to-clut").setEnabled(true);
    }

    private final void createLayout() {
        PanLabel rangeLabel = PanLabel.createSmall("Scale Range: ");
        PanLabel minLabel = PanLabel.createSmall("Min.: ");
        PanLabel maxLabel = PanLabel.createSmall(", Max.: ");
        QuickBox rangeBox = QuickBox.createLeftBox(rangeLabel, minLabel, this.val1TF_, maxLabel, this.val2TF_, this.fitToDataButton_);
        PanLabel scalingLabel = PanLabel.createSmall("Scaling Factor: ");
        PanLabel tenLabel = PanLabel.createSmall("10^");
        QuickBox scalingBox = QuickBox.createLeftBox(scalingLabel, tenLabel, this.scalingSpinner_);
        PanLabel unitsLabel1 = PanLabel.createSmall("Units: ");
        PanLabel unitsLabel2 = PanLabel.createSmall("of ");
        QuickBox unitsBox = QuickBox.createLeftBox(unitsLabel1, this.methodCombo_, unitsLabel2, this.unitsCombo_);
        PanLabel formatLabel = PanLabel.createSmall("Tick Format: ");
        PanLabel divLabel1 = PanLabel.createSmall("\u2014 Divisions, Major: ");
        PanLabel divLabel2 = PanLabel.createSmall(", Minor: ");
        PanLabel tickSizeLabel = PanLabel.createSmall("\u2014 Size: ");
        QuickBox formatBox = QuickBox.createLeftBox(formatLabel, this.tickFormatCombo_, divLabel1, this.majorDivSpinner_, divLabel2, this.minorDivSpinner_, tickSizeLabel, this.tickSizeCombo_);
        PanLabel captionLabel = PanLabel.createSmall("Scale Caption: ");
        QuickBox captionBox = QuickBox.createLeftBox(captionLabel, this.dfltCaptionButton_, this.customCaptionButton_, this.captionTF_);
        PanLabel ctableLabel = PanLabel.createSmall("Color Table: ");
        this.ctableCombo_ = PanColorTableComboBox.createSmall("scale.colorbar", true);
        this.ctableCombo_.setSelectedItem(this.pmeta_.get("scale.colorbar"));
        PanLabel invalidsLabel = PanLabel.createSmall(", Fill Color: ");
        this.iColorCombo_ = PanColorComboBox.createSmall("scale.invalids", PaletteType.GRAYSCALE);
        this.iColorCombo_.setSelectedColor(this.pmeta_.getColor("scale.invalids"));
        QuickBox ctableBox = QuickBox.createLeftBox(ctableLabel, this.ctableCombo_, invalidsLabel, this.iColorCombo_);
        PanLabel widthLabel = PanLabel.createSmall("Colorbar Width: ");
        this.widthSpinner_ = PanIntSpinner.createSmall("scale.width", this.pmeta_.getInt("scale.width"), 25, 100, 5);
        PanLabel widthPctLabel = PanLabel.createSmall("%");
        PanLabel reversedLabel = PanLabel.createSmall(" \u2014 ");
        PanActionHash actionHash = this.pmeta_.getActionHash();
        this.reversedCB_ = PanCheckBox.createSmall("scale.reverse", (Action)actionHash.get("reverse-scale"));
        this.reversedCB_.setSelected(this.pmeta_.getBoolean("scale.reverse"));
        this.reversedCB_.setText("Reverse colors");
        QuickBox widthBox = QuickBox.createLeftBox(widthLabel, this.widthSpinner_, widthPctLabel, reversedLabel, this.reversedCB_);
        this.outlierSideCombo_ = PanEnumComboBox.createSmall("scale.outlier.side", PanColorbarOutlierSide.class);
        this.outlierShapeCombo_ = PanEnumComboBox.createSmall("scale.outlier.shape", ColorTableOutlierShape.class);
        this.outlierGapCombo_ = PanEnumComboBox.createSmall("scale.outlier.gap", PanColorbarOutlierGap.class);
        this.outlierSideCombo_.setSelectedItem(this.pmeta_.getString("scale.outlier.side"));
        this.outlierShapeCombo_.setSelectedItem(this.pmeta_.getString("scale.outlier.shape"));
        this.outlierGapCombo_.setSelectedItem(this.pmeta_.getString("scale.outlier.gap"));
        PanLabel outlierLabel1 = PanLabel.createSmall("Outliers on: ");
        PanLabel outlierLabel2 = PanLabel.createSmall(", Shape: ");
        PanLabel outlierLabel3 = PanLabel.createSmall(", Gap: ");
        QuickBox outlier = QuickBox.createLeftBox(outlierLabel1, this.outlierSideCombo_, outlierLabel2, this.outlierShapeCombo_, outlierLabel3, this.outlierGapCombo_);
        PanLabel captionPlaceLabel = PanLabel.createSmall("Caption Location: ");
        this.scaleCapPlaceCombo_ = PanEnumComboBox.createSmall("scale.label.location", PanScaleCaptionLocation.class);
        this.scaleCapPlaceCombo_.setSelectedItem(this.pmeta_.getString("scale.label.location"));
        QuickBox captionPlaceBox = QuickBox.createLeftBox(captionPlaceLabel, this.scaleCapPlaceCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)rangeBox, new FGConstraint(0, 0));
        this.add((Component)scalingBox, new FGConstraint(0, 1));
        this.add((Component)unitsBox, new FGConstraint(0, 2));
        this.add((Component)formatBox, new FGConstraint(0, 3));
        this.add((Component)captionBox, new FGConstraint(0, 4));
        this.add((Component)ctableBox, new FGConstraint(1, 0));
        this.add((Component)widthBox, new FGConstraint(1, 1));
        this.add((Component)outlier, new FGConstraint(1, 2));
        this.add((Component)captionPlaceBox, new FGConstraint(1, 4));
        GuiUtils.matchLabelWidths(rangeLabel, scalingLabel, unitsLabel1, formatLabel, captionLabel);
        GuiUtils.matchLabelWidths(ctableLabel, widthLabel, outlierLabel1);
        this.val1TF_.setMaximumSize(this.val1TF_.getPreferredSize());
        this.val2TF_.setMaximumSize(this.val2TF_.getPreferredSize());
        int tfh = this.captionTF_.getPreferredSize().height;
        this.captionTF_.setMinimumSize(new Dimension(150, tfh));
        this.captionTF_.setPreferredSize(new Dimension(225, tfh));
        this.captionTF_.setMaximumSize(new Dimension(1000, tfh));
    }

    protected final void attachListeners() {
        this.ctableCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            Object item = this.ctableCombo_.getSelectedItem();
            this.pmeta_.put("scale.colorbar", item);
        });
        this.widthSpinner_.addChangeListener(e -> this.pmeta_.setInt("scale.width", this.widthSpinner_.getIntValue()));
        this.iColorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.iColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("scale.invalids"))) {
                this.pmeta_.setColor("scale.invalids", cnew);
            }
        });
        this.outlierShapeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("scale.outlier.shape", this.outlierShapeCombo_.getStringValue());
        });
        this.outlierSideCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("scale.outlier.side", this.outlierSideCombo_.getStringValue());
        });
        this.outlierGapCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("scale.outlier.gap", this.outlierGapCombo_.getStringValue());
        });
        this.scaleCapPlaceCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("scale.label.location", this.scaleCapPlaceCombo_.getStringValue());
            this.refresh();
        });
        this.pmeta_.addPlotPropertyListener(this);
        this.data_.addDataListener(this);
        PanUtils.getColorTableResourceList().addListDataListener(this);
    }

    public void setColorTable(AbstractColorTable cb) {
        if (cb != this.ctableCombo_.getSelectedItem()) {
            this.ctableCombo_.setSelectedItem(cb);
        }
        this.pmeta_.put("scale.colorbar", (Object)cb);
    }

    public void setReverseColorbar(boolean reverse) {
        this.reversedCB_.setSelected(reverse);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        PanPlotType plotType = (PanPlotType)this.pmeta_.get("type");
        AbstractColorTable clut = (AbstractColorTable)this.ctableCombo_.getSelectedItem();
        boolean autoScaleOn = this.pmeta_.getBoolean("scale.autofit");
        boolean clutHasRange = clut.hasRangeLimits();
        boolean isLinePlot = false;
        if (plotType.equals(PanPlotType.LON_LAT)) {
            isLinePlot = this.pmeta_.getString("lonlat.lltype").toLowerCase().contains("zon");
        }
        boolean isNotLinePlot = !isLinePlot;
        PanActionHash actionHash = this.pmeta_.getActionHash();
        actionHash.enable("reverse-scale", isNotLinePlot);
        actionHash.enable("fit-scale-to-clut", isNotLinePlot && clutHasRange && !autoScaleOn);
        this.ctableCombo_.setEnabled(isNotLinePlot);
        this.reversedCB_.setEnabled(isNotLinePlot);
        this.iColorCombo_.setEnabled(isNotLinePlot);
        this.outlierShapeCombo_.setEnabled(isNotLinePlot);
        boolean capVis = !this.scaleCapPlaceCombo_.getSelectedItem().equals(PanScaleCaptionLocation.NONE);
        this.customCaptionButton_.setEnabled(capVis);
        this.captionTF_.setEnabled(capVis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanScaleControls2D panScaleControls2D = this;
        synchronized (panScaleControls2D) {
            if (this.ctableCombo_ != null) {
                this.ctableCombo_.flush();
                this.ctableCombo_ = null;
            }
            this.iColorCombo_ = null;
            super.flush();
        }
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        LOGGER.debug("Not implemented.");
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        JFrame pframe = GuiUtils.getParentFrame(this);
        if (jf == pframe) {
            AbstractColorTable act = (AbstractColorTable)PanUtils.getColorTableResourceList().getBackingObject(e.getIndex0());
            EventQueue.invokeLater(() -> this.ctableCombo_.setSelectedItem(act));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }
}

