/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanFontComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLabelControls
extends PanAbstractControlsPanel {
    private PanTextField titleTF_;
    private PanTextField subtitleTF_;
    private PanTextField leftFnTF_;
    private PanTextField rightFnTF_;
    private PanCheckBox minmaxNoteCB_;
    private PanLabel minmaxClickLabel_;
    private PanStringComboBox minmaxFormatCombo_;
    private PanFontComboBox fontCombo_;
    private PanColorComboBox bgColorCombo_;

    public PanLabelControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("label-controls", pmeta, mbar);
        this.createLayout(mbar);
        this.attachListeners();
    }

    private final void createLayout(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        PanLabel titleLabel = PanLabel.createSmall("Title:\u2009");
        this.titleTF_ = PanTextField.createSmall("title.text", this.pmeta_.getString("title.text"), 0);
        QuickBox titleBox = QuickBox.createHorizontalBox(titleLabel, this.titleTF_);
        PanLabel subtitleLabel = PanLabel.createSmall("Subtitle:\u2009");
        this.subtitleTF_ = PanTextField.createSmall("subtitle.text", "", 0);
        QuickBox subtitleBox = QuickBox.createHorizontalBox(subtitleLabel, this.subtitleTF_);
        PanLabel leftFnLabel = PanLabel.createSmall("Left Footnote:\u2009");
        PanLabel rightFnLabel = PanLabel.createSmall("Right Footnote:\u2009");
        PanLabel centerFnLabel = PanLabel.createSmall("Center Footnote:\u2009");
        PanLabel formatFnLabel = PanLabel.createSmall("  \u2014  Format:\u2009");
        this.leftFnTF_ = PanTextField.createSmall("footnote.left", "", 30);
        this.rightFnTF_ = PanTextField.createSmall("footnote.right", "", 30);
        this.minmaxNoteCB_ = PanCheckBox.createSmall("scale.minmax.note", "", this.pmeta_.getBoolean("scale.minmax.note"));
        this.minmaxClickLabel_ = PanLabel.createSmall("Show data min-max");
        this.minmaxFormatCombo_ = PanStringComboBox.createSmallNumberFormatCB("scale.minmax.format");
        this.minmaxFormatCombo_.insertItemAt("Same as Scale Ticks", 0);
        this.minmaxFormatCombo_.setEnabled(this.minmaxNoteCB_.isSelected());
        String mmf = this.pmeta_.getString("scale.minmax.format");
        if (mmf == null || mmf.isEmpty() || mmf.toLowerCase().startsWith("same")) {
            this.minmaxFormatCombo_.setSelectedIndex(0);
        } else {
            this.minmaxFormatCombo_.setSelectedItem(mmf);
        }
        QuickBox leftFnBox = QuickBox.createLeftBox(leftFnLabel, this.leftFnTF_);
        QuickBox rightFnBox = QuickBox.createLeftBox(rightFnLabel, this.rightFnTF_);
        QuickBox centerFnBox = QuickBox.createLeftBox(centerFnLabel, this.minmaxNoteCB_, this.minmaxClickLabel_, formatFnLabel, this.minmaxFormatCombo_);
        PanLabel fontLabel = PanLabel.createSmall("Labels Typeface:\u2009");
        this.fontCombo_ = new PanFontComboBox(PanGuiSize.SMALL, "font.master");
        this.fontCombo_.setSelectedItem(this.pmeta_.getString("font.master"));
        PanLabel backgroundLabel = PanLabel.createSmall("Background:\u2009");
        BackgroundAction backgroundAction = new BackgroundAction();
        this.pmeta_.putAction("background", backgroundAction);
        this.bgColorCombo_ = PanColorComboBox.createSmall("color.background", PaletteType.BLACK_WHITE);
        this.bgColorCombo_.setSelectedColor(this.pmeta_.getColor("color.background"));
        this.bgColorCombo_.setAction(backgroundAction);
        plotMenu.getItemByName("background").setAction(backgroundAction);
        plotMenu.getItemByName("background").setText(this.getOppositeBackgroundName() + " Background");
        plotMenu.getItemByName("background").setEnabled(true);
        QuickBox bBox1 = QuickBox.createLeftBox(fontLabel, this.fontCombo_);
        QuickBox bBox2 = QuickBox.createLeftBox(backgroundLabel, this.bgColorCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)titleBox, new FGConstraint(0, 0));
        this.add((Component)subtitleBox, new FGConstraint(0, 1));
        this.add((Component)leftFnBox, new FGConstraint(0, 2));
        this.add((Component)centerFnBox, new FGConstraint(0, 3));
        this.add((Component)rightFnBox, new FGConstraint(0, 4));
        this.add((Component)bBox1, new FGConstraint(1, 0));
        this.add((Component)bBox2, new FGConstraint(1, 1));
        GuiUtils.matchLabelWidths(titleLabel, subtitleLabel, leftFnLabel, centerFnLabel, rightFnLabel);
        int tfh = this.titleTF_.getPreferredSize().height;
        Dimension ddpref = new Dimension(480, tfh);
        Dimension ddmax = new Dimension(1000, tfh);
        Dimension ddmin = new Dimension(400, tfh);
        this.titleTF_.setPreferredSize(ddpref);
        this.titleTF_.setMinimumSize(ddmin);
        this.titleTF_.setMaximumSize(ddmax);
        this.subtitleTF_.setPreferredSize(ddpref);
        this.subtitleTF_.setMinimumSize(ddmin);
        this.subtitleTF_.setMaximumSize(ddmax);
        backgroundLabel.setPreferredSize(fontLabel.getPreferredSize());
        backgroundLabel.setMaximumSize(backgroundLabel.getPreferredSize());
        Dimension dd = this.fontCombo_.getPreferredSize();
        if (dd.width > 240) {
            dd.width = 240;
            this.fontCombo_.setPreferredSize(dd);
            this.fontCombo_.setMaximumSize(dd);
        }
    }

    private final void attachListeners() {
        this.titleTF_.getDocument().addDocumentListener(new PanCaptionListener(this.titleTF_, this.pmeta_, "title.text"));
        this.subtitleTF_.getDocument().addDocumentListener(new PanCaptionListener(this.subtitleTF_, this.pmeta_, "subtitle.text"));
        this.leftFnTF_.getDocument().addDocumentListener(new PanCaptionListener(this.leftFnTF_, this.pmeta_, "footnote.left"));
        this.rightFnTF_.getDocument().addDocumentListener(new PanCaptionListener(this.rightFnTF_, this.pmeta_, "footnote.right"));
        this.fontCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("font.master", this.fontCombo_.getSelectedItem().toString());
        });
        this.minmaxNoteCB_.addItemListener(e -> {
            boolean bb = this.minmaxNoteCB_.isSelected();
            this.pmeta_.setBoolean("scale.minmax.note", bb);
            this.minmaxFormatCombo_.setEnabled(bb);
        });
        this.minmaxClickLabel_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean bb = !PanLabelControls.this.minmaxNoteCB_.isSelected();
                PanLabelControls.this.minmaxNoteCB_.setSelected(bb);
                PanLabelControls.this.pmeta_.setBoolean("scale.minmax.note", bb);
                PanLabelControls.this.minmaxFormatCombo_.setEnabled(bb);
            }
        });
        this.minmaxFormatCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            String format = this.minmaxFormatCombo_.getSelectedString();
            this.pmeta_.setString("scale.minmax.format", format);
        });
    }

    private String getOppositeBackgroundName() {
        Color c = this.bgColorCombo_.getSelectedColor();
        if (c.equals(Color.BLACK)) {
            return "White";
        }
        return "Black";
    }

    class BackgroundAction
    extends AbstractAction {
        private boolean busy_;

        BackgroundAction() {
            super("background");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanPlotFrame pf;
            Object source;
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            Object object = source = e == null ? null : e.getSource();
            if (source instanceof JMenuItem) {
                String ctext = ((JMenuItem)source).getText();
                Color cnew = ctext.startsWith("Black") ? Color.BLACK : Color.WHITE;
                PanLabelControls.this.bgColorCombo_.setSelectedColor(cnew);
            }
            if ((pf = PanLabelControls.this.getParentFrame()) == null) {
                this.busy_ = false;
                return;
            }
            PanMenuBar mbar = pf.getPanMenuBar();
            mbar.getItemByName("plot-menu", "background").setText(PanLabelControls.this.getOppositeBackgroundName() + " Background");
            Color cold = PanLabelControls.this.pmeta_.getColor("color.background");
            Color cnew = PanLabelControls.this.bgColorCombo_.getSelectedColor();
            if (!cnew.equals(cold)) {
                PanLabelControls.this.pmeta_.setColor("color.background", cnew);
            }
            this.busy_ = false;
        }
    }
}

