/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanContourStyle;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanContourControls
extends PanAbstractControlsPanel {
    private PanEnumComboBox styleCombo_;
    private PanEnumComboBox locationCombo_;
    private PanColorComboBox colorCombo_;
    private PanIntSpinner weightSpinner_;
    private PanCheckBox labelVisCB_;
    private PanLabel labelSizeLabel_;
    private PanFloatComboBox labelSizeCombo_;

    public PanContourControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("contour-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanContourStyle cstyle = PanContourStyle.matching(this.pmeta_.getString("contour.style"));
        PanLabel styleLabel = PanLabel.createSmall("Style: ");
        this.styleCombo_ = PanEnumComboBox.createSmall("contour.style", PanContourStyle.class);
        this.styleCombo_.setSelectedItem(cstyle);
        QuickBox cbox1 = QuickBox.createLeftBox(styleLabel, this.styleCombo_);
        PanLabel colorLabel = PanLabel.createSmall("Color: ");
        PanLabel opacityLabel = PanLabel.createSmall(", Weight: ");
        PanLabel cPctLabel = PanLabel.createSmall("%");
        this.colorCombo_ = PanColorComboBox.createSmallRainbow("contour.color");
        this.weightSpinner_ = PanIntSpinner.createSmallWeight("contour.weight", this.pmeta_.getInt("contour.weight"), 200);
        this.colorCombo_.setSelectedColor(this.pmeta_.getColor("contour.color"));
        QuickBox cbox3 = QuickBox.createLeftBox(colorLabel, this.colorCombo_, opacityLabel, this.weightSpinner_, cPctLabel);
        PanLabel locationLabel = PanLabel.createSmall("Locations: ");
        this.locationCombo_ = PanEnumComboBox.createSmall("contour.location", PanContourLocation.class);
        this.locationCombo_.setSelectedItem(this.pmeta_.getString("contour.location"));
        QuickBox cbox2 = QuickBox.createLeftBox(locationLabel, this.locationCombo_);
        PanLabel labelLabel = PanLabel.createSmall("Labels: ");
        this.labelVisCB_ = PanCheckBox.createSmall("contour.label.vis", "Visible,", this.pmeta_.getBoolean("contour.label.vis"));
        this.labelSizeLabel_ = PanLabel.createSmall(" Size: ");
        this.labelSizeCombo_ = PanFloatComboBox.createSmall("contour.label.size", 5.0f, 10.0f);
        this.labelSizeCombo_.setValue(this.pmeta_.getFloat("contour.label.size"));
        this.labelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
        this.labelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
        this.labelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        QuickBox cbox4 = QuickBox.createLeftBox(labelLabel, this.labelVisCB_, this.labelSizeLabel_, this.labelSizeCombo_);
        GuiUtils.matchLabelWidths(styleLabel, locationLabel, colorLabel);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 3, 0, 2);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.add((Component)cbox1, new FGConstraint(0, 0));
        this.add((Component)cbox3, new FGConstraint(0, 1));
        this.add((Component)cbox2, new FGConstraint(0, 2));
        this.add((Component)cbox4, new FGConstraint(1, 0));
    }

    private final void attachListeners() {
        this.styleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PanContourStyle cstyle = (PanContourStyle)this.styleCombo_.getSelectedItem();
            this.pmeta_.put("contour.style", (Object)cstyle.toString());
            this.labelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
            this.labelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
            this.labelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        });
        this.colorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.colorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("contour.color"))) {
                this.pmeta_.setColor("contour.color", cnew);
            }
        });
        this.weightSpinner_.addChangeListener(e -> this.pmeta_.setInt("contour.weight", this.weightSpinner_.getIntValue()));
        this.locationCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("contour.location", (Object)this.locationCombo_.getStringValue());
        });
        this.labelVisCB_.addItemListener(e -> this.pmeta_.setBoolean("contour.label.vis", this.labelVisCB_.isSelected()));
        this.labelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.labelSizeCombo_.getValue();
            this.pmeta_.setFloat("contour.label.size", value);
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        boolean enabled = true;
        PanPlotType plotType = (PanPlotType)this.pmeta_.get("type");
        if (plotType.equals(PanPlotType.LON_LAT)) {
            enabled = !this.pmeta_.getString("lonlat.lltype").toLowerCase().contains("zon");
        }
        PanContourStyle cstyle = (PanContourStyle)this.styleCombo_.getSelectedItem();
        this.styleCombo_.setEnabled(enabled);
        this.locationCombo_.setEnabled(enabled);
        this.colorCombo_.setEnabled(enabled);
        this.weightSpinner_.setEnabled(enabled);
        this.labelVisCB_.setEnabled(enabled && cstyle != PanContourStyle.NONE);
        this.labelSizeCombo_.setEnabled(enabled && cstyle != PanContourStyle.NONE);
    }
}

